/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.libraries.model;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.endpoints.TemplateFactory;
import org.apache.synapse.deployers.SynapseArtifactDeploymentException;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.libraries.model.ArtifactFile;
import org.apache.synapse.libraries.model.SynapseLibrary;
import org.apache.synapse.mediators.template.TemplateMediator;

public class LibraryArtifact
implements SynapseArtifact {
    protected String name;
    protected String type;
    protected String description;
    String extractedPath;
    ArtifactFile file;
    int unresolvedDeps = 0;
    Map<String, LibraryArtifact> subArtifacts;
    private LibraryArtifact parent;

    public LibraryArtifact(String name) {
        this.name = name;
        this.subArtifacts = new HashMap<String, LibraryArtifact>();
    }

    public void setupFile(String filename) {
        if (filename != null && !"".equals(filename)) {
            if (!"synapse/template".equals(this.getArtifactType())) {
                throw new SynapseArtifactDeploymentException("Unsupported Type for synapse lib artifact.");
            }
        } else {
            throw new SynapseArtifactDeploymentException("Invalid file specified for lib artifact.");
        }
        this.file = new TemplateArtifactFile(filename);
    }

    private String getArtifactType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.parent != null) {
            return this.parent.getArtifactType();
        }
        return "";
    }

    public void addSubArtifact(LibraryArtifact artifact) {
        if (artifact != null) {
            this.subArtifacts.put(artifact.toString(), artifact);
            ++this.unresolvedDeps;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeafArtifact() {
        return this.file != null;
    }

    public void loadComponentsInto(SynapseLibrary library) {
        for (String artifactName : this.subArtifacts.keySet()) {
            LibraryArtifact artifact = this.subArtifacts.get(artifactName);
            if (artifact.isLeafArtifact()) {
                String templateName;
                this.delegateClassLoading(artifact, library);
                Object template = artifact.file.build();
                if (!(artifact.file instanceof TemplateArtifactFile)) continue;
                if (template instanceof TemplateMediator) {
                    templateName = ((TemplateMediator)template).getName();
                    library.addComponent(this.getQualifiedName(library.getPackage(), templateName), template);
                    continue;
                }
                if (template instanceof Template) {
                    templateName = ((Template)template).getName();
                    library.addComponent(this.getQualifiedName(library.getPackage(), templateName), template);
                    continue;
                }
                if (template != null) {
                    library.addComponent(this.getQualifiedName(library.getPackage(), artifact.getName()), template);
                    continue;
                }
                throw new SynapseArtifactDeploymentException("Cannot load components into Synapse Library. Component cannot be built for " + artifactName);
            }
            artifact.loadComponentsInto(library);
        }
    }

    private void delegateClassLoading(LibraryArtifact artifact, SynapseLibrary library) {
        Properties classLoadingProperties = new Properties();
        classLoadingProperties.put("synapse.lib.classloader", library.getLibClassLoader());
        artifact.file.setProperties(classLoadingProperties);
    }

    private String getQualifiedName(String aPackage, String templateName) {
        return aPackage + "." + templateName;
    }

    public void setPath(String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        this.extractedPath = path;
    }

    public String toString() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setParent(LibraryArtifact parent) {
        this.parent = parent;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static class Dependency {
        private String name;
        boolean markAsResolved = false;

        public Dependency(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean resolveWith(LibraryArtifact artifact) {
            this.markAsResolved = this.name.equals(artifact.name);
            return this.markAsResolved;
        }

        public boolean isResolved() {
            return this.markAsResolved;
        }
    }

    private class TemplateArtifactFile
    extends ArtifactFile {
        public TemplateArtifactFile(String fileXmlPath) {
            super(LibraryArtifact.this.extractedPath + fileXmlPath);
        }

        @Override
        public Object build() {
            SynapseArtifact templateObject = null;
            OMElement element = this.configurationElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sequence"));
            if (element != null) {
                String name = element.getAttributeValue(new QName("", "name"));
                try {
                    templateObject = MediatorFactoryFinder.getInstance().getMediator(this.configurationElement, this.properties);
                }
                catch (Exception e) {
                    String msg = "Template configuration : " + name + " cannot be builtfor Synapse Library artifact : " + LibraryArtifact.this.name;
                    throw new SynapseArtifactDeploymentException(msg, e);
                }
                return templateObject;
            }
            element = this.configurationElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"));
            if (element != null) {
                TemplateFactory templateFactory = new TemplateFactory();
                String name = element.getAttributeValue(new QName("", "name"));
                try {
                    templateObject = templateFactory.createEndpointTemplate(this.configurationElement, this.properties);
                }
                catch (Exception e) {
                    String msg = "Endpoint Template: " + name + "configuration cannot be built for Synapse Library artifact : " + LibraryArtifact.this.name;
                    throw new SynapseArtifactDeploymentException(msg, e);
                }
            }
            return templateObject;
        }
    }
}

