/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.judo;

import com.judoscript.Expr;
import com.judoscript.JudoUtil;
import com.judoscript.ObjectInstance;
import com.judoscript.RT;
import com.judoscript.RuntimeContext;
import com.judoscript.RuntimeGlobalContext;
import com.judoscript.Script;
import com.judoscript.ValueSpecial;
import com.judoscript.Variable;
import com.judoscript.bio.JavaObject;
import com.judoscript.parser.JudoParser;
import com.judoscript.util.LinePrintWriter;
import com.sun.script.judo.JudoScriptEngineFactory;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JudoScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private ScriptEngineFactory factory;
    private volatile Script judoscript;
    private ThreadLocal<MyRuntimeGlobalContext> cache = new ThreadLocal();
    private static final /* synthetic */ Class class$java$lang$Object;

    @Override
    public CompiledScript compile(String code) throws ScriptException {
        return this.compile(new StringReader(code));
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return new JudoCompiledScript(this.compileScript(reader, this.context));
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args, class$java$lang$Object == null ? (class$java$lang$Object = JudoScriptEngine.class$("java.lang.Object")) : class$java$lang$Object);
    }

    @Override
    public Object invokeMethod(Object obj, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.invokeImpl(obj, name, args, class$java$lang$Object == null ? (class$java$lang$Object = JudoScriptEngine.class$("java.lang.Object")) : class$java$lang$Object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInterface(Object obj, Class<T> clazz) {
        JudoScriptEngine judoScriptEngine = this;
        synchronized (judoScriptEngine) {
            if (this.judoscript == null) {
                return null;
            }
        }
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(obj, clazz);
    }

    public <T> T getInterface(Class<T> clazz) {
        return this.makeInterface(null, clazz);
    }

    private <T> T makeInterface(final Object obj, Class<T> clazz) {
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                return JudoScriptEngine.access$100(JudoScriptEngine.this, obj, m.getName(), args, m.getReturnType());
            }
        });
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        return this.eval((Reader)new StringReader(str), ctx);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        Object script = this.compileScript(reader, ctx);
        return this.evalScript(script, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JudoScriptEngine judoScriptEngine = this;
        synchronized (judoScriptEngine) {
            if (this.factory == null) {
                this.factory = new JudoScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private Object compileScript(Reader reader, ScriptContext ctx) throws ScriptException {
        String fileName = (String)ctx.getAttribute("javax.script.filename");
        if (fileName == null) {
            fileName = "<unknown>";
        }
        try {
            return JudoParser.parse(null, null, (Reader)reader, null, (long)0L, (boolean)false);
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private MyRuntimeGlobalContext getRuntimeContext() {
        MyRuntimeGlobalContext rtc = this.cache.get();
        if (rtc == null) {
            rtc = new MyRuntimeGlobalContext(null);
            this.cache.set(rtc);
            RT.pushContext((RuntimeContext)rtc);
        }
        return rtc;
    }

    private synchronized void saveScript(Script script) {
        if (this.judoscript != null) {
            script.acceptDecls(this.judoscript);
        }
        this.judoscript = script;
    }

    private Object evalScript(Object script, ScriptContext ctx) throws ScriptException {
        MyRuntimeGlobalContext rtc = this.getRuntimeContext();
        ctx.setAttribute("context", ctx, 100);
        ScriptContext oldContext = rtc.getScriptContext();
        try {
            this.saveScript((Script)script);
            rtc.setScriptContext(ctx);
            rtc.setScript(this.judoscript);
            this.judoscript.start((RuntimeGlobalContext)rtc);
            Object var5_5 = null;
            return var5_5;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            if (oldContext != null) {
                rtc.setScriptContext(oldContext);
            }
        }
    }

    private Object judoToJava(Variable value, Class type) throws Throwable {
        if (type.isPrimitive()) {
            String s;
            if (type == Boolean.TYPE) {
                return new Boolean(value.getBoolValue());
            }
            if (type == Byte.TYPE) {
                return new Byte((byte)value.getLongValue());
            }
            if (type == Short.TYPE) {
                return new Short((short)value.getLongValue());
            }
            if (type == Integer.TYPE) {
                return new Integer((int)value.getLongValue());
            }
            if (type == Long.TYPE) {
                return new Long(value.getLongValue());
            }
            if (type == Float.TYPE) {
                return new Float((float)value.getDoubleValue());
            }
            if (type == Double.TYPE) {
                return new Double(value.getDoubleValue());
            }
            if (type == Character.TYPE && (s = value.getStringValue()).length() == 1) {
                return new Character(s.charAt(0));
            }
        }
        return value.isNil() ? null : value.getObjectValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeImpl(Object obj, String name, Object[] args, Class returnType) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("method name is null");
        }
        JudoScriptEngine judoScriptEngine = this;
        synchronized (judoScriptEngine) {
            if (this.judoscript == null) {
                throw new NoSuchMethodException(name);
            }
        }
        Object thiz = null;
        if (obj != null) {
            thiz = obj instanceof ObjectInstance ? (ObjectInstance)obj : new JavaObject(obj);
        }
        MyRuntimeGlobalContext rtc = this.getRuntimeContext();
        this.context.setAttribute("context", this.context, 100);
        ScriptContext oldContext = rtc.getScriptContext();
        try {
            int len = args == null ? 0 : args.length;
            Expr[] params = new Expr[len];
            for (int i = 0; i < len; ++i) {
                params[i] = args[i] == null ? ValueSpecial.NIL : JudoUtil.toVariable((Object)args[i]);
            }
            Variable result = thiz == null ? this.judoscript.invoke(name, params, null) : thiz.invoke(name, params, null);
            Object object = this.judoToJava(result, returnType);
            return object;
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        catch (Throwable t) {
            throw (ScriptException)new ScriptException(t.getMessage()).initCause(t);
        }
        finally {
            if (oldContext != null) {
                rtc.setScriptContext(oldContext);
            }
        }
    }

    static Object access$000(JudoScriptEngine x0, Object x1, ScriptContext x2) throws ScriptException {
        return x0.evalScript(x1, x2);
    }

    static Object access$100(JudoScriptEngine x0, Object x1, String x2, Object[] x3, Class x4) throws ScriptException, NoSuchMethodException {
        return x0.invokeImpl(x1, x2, x3, x4);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class MyRuntimeGlobalContext
    extends RuntimeGlobalContext {
        private BufferedReader in;
        private LinePrintWriter out;
        private LinePrintWriter err;
        private ScriptContext ctx;

        private MyRuntimeGlobalContext() {
        }

        void setScriptContext(ScriptContext ctx) {
            this.ctx = ctx;
            this.in = new BufferedReader(ctx.getReader());
            this.out = new LinePrintWriter(ctx.getWriter());
            this.err = new LinePrintWriter(ctx.getErrorWriter());
        }

        ScriptContext getScriptContext() {
            return this.ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Variable resolveVariable(String name) throws Throwable {
            Variable v = super.resolveVariable(name);
            if (v == ValueSpecial.UNDEFINED) {
                ScriptContext scriptContext = this.ctx;
                synchronized (scriptContext) {
                    int scope = this.ctx.getAttributesScope(name);
                    if (scope != -1) {
                        Object obj = this.ctx.getAttribute(name, scope);
                        v = JudoUtil.toVariable((Object)obj);
                    }
                }
            }
            return v;
        }

        public BufferedReader getIn() {
            return this.in;
        }

        public LinePrintWriter getOut() {
            return this.out;
        }

        public LinePrintWriter getErr() {
            return this.err;
        }

        MyRuntimeGlobalContext(1 x0) {
            this();
        }
    }

    private class JudoCompiledScript
    extends CompiledScript {
        private Object script;

        JudoCompiledScript(Object script) {
            this.script = script;
        }

        public ScriptEngine getEngine() {
            return JudoScriptEngine.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return JudoScriptEngine.access$000(JudoScriptEngine.this, this.script, ctx);
        }
    }
}

