/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccountStatus;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DuoSecurityDetermineUserAccountAction
extends AbstractMultifactorAuthenticationAction<DuoSecurityMultifactorAuthenticationProvider> {
    protected Event doExecute(RequestContext requestContext) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authentication.getPrincipal());
        DuoSecurityAuthenticationService duoAuthenticationService = ((DuoSecurityMultifactorAuthenticationProvider)this.provider).getDuoAuthenticationService();
        DuoSecurityUserAccount account = duoAuthenticationService.getUserAccount(principal.getId());
        EventFactorySupport eventFactorySupport = new EventFactorySupport();
        if (account.getStatus() == DuoSecurityUserAccountStatus.ENROLL && StringUtils.isNotBlank((CharSequence)((DuoSecurityMultifactorAuthenticationProvider)this.provider).getRegistrationUrl())) {
            requestContext.getFlowScope().put("duoRegistrationUrl", (Object)((DuoSecurityMultifactorAuthenticationProvider)this.provider).getRegistrationUrl());
            return eventFactorySupport.event((Object)this, "enroll");
        }
        if (account.getStatus() == DuoSecurityUserAccountStatus.ALLOW) {
            return eventFactorySupport.event((Object)this, "bypass");
        }
        if (account.getStatus() == DuoSecurityUserAccountStatus.DENY) {
            return eventFactorySupport.event((Object)this, "deny");
        }
        if (account.getStatus() == DuoSecurityUserAccountStatus.UNAVAILABLE) {
            return eventFactorySupport.event((Object)this, "unavailable");
        }
        return this.success();
    }
}

