/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConfigurationProperties(prefix="springdoc")
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class SpringDocConfigProperties {
    private boolean showActuator;
    private Webjars webjars = new Webjars();
    private ApiDocs apiDocs = new ApiDocs();
    private List<String> packagesToScan;
    private List<String> packagesToExclude;
    private List<String> pathsToMatch;
    private List<String> pathsToExclude;
    private List<String> producesToMatch;
    private List<String> headersToMatch;
    private List<String> consumesToMatch;
    private Cache cache = new Cache();
    private List<GroupConfig> groupConfigs = new ArrayList<GroupConfig>();
    private boolean autoTagClasses = true;
    private boolean modelAndViewAllowed;
    private Boolean overrideWithGenericResponse;
    private boolean removeBrokenReferenceDefinitions = true;
    private boolean writerWithDefaultPrettyPrinter;
    private boolean writerWithOrderByKeys;
    private String defaultConsumesMediaType = "application/json";
    private String defaultProducesMediaType = "*/*";
    private boolean useFqn;
    private boolean showLoginEndpoint;
    private boolean preLoadingEnabled;
    private boolean useManagementPort;
    private boolean disableI18n;
    private boolean showSpringCloudFunctions;
    private boolean defaultFlatParamObject;
    private boolean defaultSupportFormData = true;
    private ModelConverters modelConverters = new ModelConverters();
    private ModelConverters.SortConverter sortConverter = new ModelConverters.SortConverter();

    public boolean isDefaultSupportFormData() {
        return this.defaultSupportFormData;
    }

    public void setDefaultSupportFormData(boolean defaultSupportFormData) {
        this.defaultSupportFormData = defaultSupportFormData;
    }

    public ModelConverters.SortConverter getSortConverter() {
        return this.sortConverter;
    }

    public void setSortConverter(ModelConverters.SortConverter sortConverter) {
        this.sortConverter = sortConverter;
    }

    public boolean isShowSpringCloudFunctions() {
        return this.showSpringCloudFunctions;
    }

    public void setShowSpringCloudFunctions(boolean showSpringCloudFunctions) {
        this.showSpringCloudFunctions = showSpringCloudFunctions;
    }

    public boolean isDefaultFlatParamObject() {
        return this.defaultFlatParamObject;
    }

    public void setDefaultFlatParamObject(boolean defaultFlatParamObject) {
        this.defaultFlatParamObject = defaultFlatParamObject;
    }

    public ModelConverters getModelConverters() {
        return this.modelConverters;
    }

    public void setModelConverters(ModelConverters modelConverters) {
        this.modelConverters = modelConverters;
    }

    public boolean isUseManagementPort() {
        return this.useManagementPort;
    }

    public void setUseManagementPort(boolean useManagementPort) {
        this.useManagementPort = useManagementPort;
    }

    public List<String> getProducesToMatch() {
        return this.producesToMatch;
    }

    public void setProducesToMatch(List<String> producesToMatch) {
        this.producesToMatch = producesToMatch;
    }

    public List<String> getHeadersToMatch() {
        return this.headersToMatch;
    }

    public void setHeadersToMatch(List<String> headersToMatch) {
        this.headersToMatch = headersToMatch;
    }

    public List<String> getConsumesToMatch() {
        return this.consumesToMatch;
    }

    public void setConsumesToMatch(List<String> consumesToMatch) {
        this.consumesToMatch = consumesToMatch;
    }

    public boolean isUseFqn() {
        return this.useFqn;
    }

    public void setUseFqn(boolean useFqn) {
        this.useFqn = useFqn;
    }

    public boolean isAutoTagClasses() {
        return this.autoTagClasses;
    }

    public void setAutoTagClasses(boolean autoTagClasses) {
        this.autoTagClasses = autoTagClasses;
    }

    public boolean isModelAndViewAllowed() {
        return this.modelAndViewAllowed;
    }

    public void setModelAndViewAllowed(boolean modelAndViewAllowed) {
        this.modelAndViewAllowed = modelAndViewAllowed;
    }

    public List<String> getPackagesToExclude() {
        return this.packagesToExclude;
    }

    public void setPackagesToExclude(List<String> packagesToExclude) {
        this.packagesToExclude = packagesToExclude;
    }

    public List<String> getPathsToExclude() {
        return this.pathsToExclude;
    }

    public void setPathsToExclude(List<String> pathsToExclude) {
        this.pathsToExclude = pathsToExclude;
    }

    public boolean isShowLoginEndpoint() {
        return this.showLoginEndpoint;
    }

    public void setShowLoginEndpoint(boolean showLoginEndpoint) {
        this.showLoginEndpoint = showLoginEndpoint;
    }

    public List<String> getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setPackagesToScan(List<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public boolean isShowActuator() {
        return this.showActuator;
    }

    public void setShowActuator(boolean showActuator) {
        this.showActuator = showActuator;
    }

    public Webjars getWebjars() {
        return this.webjars;
    }

    public void setWebjars(Webjars webjars) {
        this.webjars = webjars;
    }

    public ApiDocs getApiDocs() {
        return this.apiDocs;
    }

    public void setApiDocs(ApiDocs apiDocs) {
        this.apiDocs = apiDocs;
    }

    public List<String> getPathsToMatch() {
        return this.pathsToMatch;
    }

    public void setPathsToMatch(List<String> pathsToMatch) {
        this.pathsToMatch = pathsToMatch;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public boolean isCacheDisabled() {
        return this.cache.isDisabled();
    }

    public List<GroupConfig> getGroupConfigs() {
        return this.groupConfigs;
    }

    public void setGroupConfigs(List<GroupConfig> groupConfigs) {
        this.groupConfigs = groupConfigs;
    }

    public void addGroupConfig(GroupConfig groupConfigs) {
        this.groupConfigs.add(groupConfigs);
    }

    public String getDefaultConsumesMediaType() {
        return this.defaultConsumesMediaType;
    }

    public void setDefaultConsumesMediaType(String defaultConsumesMediaType) {
        this.defaultConsumesMediaType = defaultConsumesMediaType;
    }

    public String getDefaultProducesMediaType() {
        return this.defaultProducesMediaType;
    }

    public void setDefaultProducesMediaType(String defaultProducesMediaType) {
        this.defaultProducesMediaType = defaultProducesMediaType;
    }

    public boolean isOverrideWithGenericResponse() {
        return this.overrideWithGenericResponse != null && this.overrideWithGenericResponse != false;
    }

    public boolean isDefaultOverrideWithGenericResponse() {
        if (this.overrideWithGenericResponse == null) {
            return true;
        }
        return this.overrideWithGenericResponse;
    }

    public void setOverrideWithGenericResponse(Boolean overrideWithGenericResponse) {
        this.overrideWithGenericResponse = overrideWithGenericResponse;
    }

    public boolean isRemoveBrokenReferenceDefinitions() {
        return this.removeBrokenReferenceDefinitions;
    }

    public void setRemoveBrokenReferenceDefinitions(boolean removeBrokenReferenceDefinitions) {
        this.removeBrokenReferenceDefinitions = removeBrokenReferenceDefinitions;
    }

    public boolean isWriterWithOrderByKeys() {
        return this.writerWithOrderByKeys;
    }

    public void setWriterWithOrderByKeys(boolean writerWithOrderByKeys) {
        this.writerWithOrderByKeys = writerWithOrderByKeys;
    }

    public boolean isWriterWithDefaultPrettyPrinter() {
        return this.writerWithDefaultPrettyPrinter;
    }

    public void setWriterWithDefaultPrettyPrinter(boolean writerWithDefaultPrettyPrinter) {
        this.writerWithDefaultPrettyPrinter = writerWithDefaultPrettyPrinter;
    }

    public void setPreLoadingEnabled(boolean preLoadingEnabled) {
        this.preLoadingEnabled = preLoadingEnabled;
    }

    public boolean isDisableI18n() {
        return this.disableI18n;
    }

    public void setDisableI18n(boolean disableI18n) {
        this.disableI18n = disableI18n;
    }

    public boolean isPreLoadingEnabled() {
        return this.preLoadingEnabled;
    }

    public static class Webjars {
        private String prefix = "/webjars";

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    public static class ApiDocs {
        private String path = "/v3/api-docs";
        private boolean enabled = true;
        private boolean resolveSchemaProperties;
        private Groups groups = new Groups();
        private OpenApiVersion version;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Groups getGroups() {
            return this.groups;
        }

        public void setGroups(Groups groups) {
            this.groups = groups;
        }

        public boolean isResolveSchemaProperties() {
            return this.resolveSchemaProperties;
        }

        public void setResolveSchemaProperties(boolean resolveSchemaProperties) {
            this.resolveSchemaProperties = resolveSchemaProperties;
        }

        public OpenApiVersion getVersion() {
            return this.version;
        }

        public void setVersion(OpenApiVersion version) {
            this.version = version;
        }

        public static enum OpenApiVersion {
            OPENAPI_3_0("3.0.1"),
            OPENAPI_3_1("3.1.0");

            private final String version;

            private OpenApiVersion(String openApiVersion) {
                this.version = openApiVersion;
            }

            public String getVersion() {
                return this.version;
            }
        }
    }

    public static class Cache {
        private boolean disabled;

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }
    }

    public static class ModelConverters {
        private DeprecatingConverter deprecatingConverter = new DeprecatingConverter();
        private PageableConverter pageableConverter = new PageableConverter();
        private PolymorphicConverter polymorphicConverter = new PolymorphicConverter();

        public DeprecatingConverter getDeprecatingConverter() {
            return this.deprecatingConverter;
        }

        public void setDeprecatingConverter(DeprecatingConverter deprecatingConverter) {
            this.deprecatingConverter = deprecatingConverter;
        }

        public PageableConverter getPageableConverter() {
            return this.pageableConverter;
        }

        public void setPageableConverter(PageableConverter pageableConverter) {
            this.pageableConverter = pageableConverter;
        }

        public PolymorphicConverter getPolymorphicConverter() {
            return this.polymorphicConverter;
        }

        public void setPolymorphicConverter(PolymorphicConverter polymorphicConverter) {
            this.polymorphicConverter = polymorphicConverter;
        }

        public static class DeprecatingConverter {
            private boolean enabled;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class PageableConverter {
            private boolean enabled;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class PolymorphicConverter {
            private boolean enabled;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class SortConverter {
            private boolean enabled;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }

    public static class GroupConfig {
        private List<String> pathsToMatch;
        private List<String> packagesToScan;
        private List<String> packagesToExclude;
        private List<String> pathsToExclude;
        private String group;
        private List<String> producesToMatch;
        private List<String> headersToMatch;
        private List<String> consumesToMatch;
        private String displayName;

        public GroupConfig() {
        }

        public GroupConfig(String group, List<String> pathsToMatch, List<String> packagesToScan, List<String> packagesToExclude, List<String> pathsToExclude, List<String> producesToMatch, List<String> consumesToMatch, List<String> headersToMatch, String displayName) {
            this.pathsToMatch = pathsToMatch;
            this.pathsToExclude = pathsToExclude;
            this.packagesToExclude = packagesToExclude;
            this.packagesToScan = packagesToScan;
            this.group = group;
            this.producesToMatch = producesToMatch;
            this.consumesToMatch = consumesToMatch;
            this.headersToMatch = headersToMatch;
            this.displayName = displayName;
        }

        public List<String> getHeadersToMatch() {
            return this.headersToMatch;
        }

        public void setHeadersToMatch(List<String> headersToMatch) {
            this.headersToMatch = headersToMatch;
        }

        public List<String> getConsumesToMatch() {
            return this.consumesToMatch;
        }

        public void setConsumesToMatch(List<String> consumesToMatch) {
            this.consumesToMatch = consumesToMatch;
        }

        public List<String> getPathsToMatch() {
            return this.pathsToMatch;
        }

        public void setPathsToMatch(List<String> pathsToMatch) {
            this.pathsToMatch = pathsToMatch;
        }

        public List<String> getPackagesToScan() {
            return this.packagesToScan;
        }

        public void setPackagesToScan(List<String> packagesToScan) {
            this.packagesToScan = packagesToScan;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public List<String> getPackagesToExclude() {
            return this.packagesToExclude;
        }

        public void setPackagesToExclude(List<String> packagesToExclude) {
            this.packagesToExclude = packagesToExclude;
        }

        public List<String> getPathsToExclude() {
            return this.pathsToExclude;
        }

        public void setPathsToExclude(List<String> pathsToExclude) {
            this.pathsToExclude = pathsToExclude;
        }

        public List<String> getProducesToMatch() {
            return this.producesToMatch;
        }

        public void setProducesToMatch(List<String> producesToMatch) {
            this.producesToMatch = producesToMatch;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class Groups {
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

