/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.OperationTimeoutException;
import org.identityconnectors.framework.impl.api.ObjectStreamHandler;
import org.identityconnectors.framework.impl.api.StreamHandlerUtil;

public class BufferedResultsProxy
implements InvocationHandler {
    private static final Log LOG = Log.getLog(BufferedResultsProxy.class);
    private final Object target;
    private final int bufferSize;
    private final long timeoutMillis;

    public BufferedResultsProxy(Object target, int bufferSize, long timeoutMillis) {
        if (target == null) {
            throw new IllegalArgumentException("Target argument must not be null!");
        }
        this.target = target;
        this.timeoutMillis = timeoutMillis == -1L ? Long.MAX_VALUE : (timeoutMillis == 0L ? 60000L : timeoutMillis);
        this.bufferSize = bufferSize < 1 ? 100 : bufferSize;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this.target, arguments);
        }
        BufferedResultsHandler bufHandler = new BufferedResultsHandler(method, this.target, arguments, this.bufferSize, this.timeoutMillis);
        ObjectStreamHandler handler = null;
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (!StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType)) continue;
            if (handler != null) {
                throw new UnsupportedOperationException("We only support operations that have a single stream handler " + method);
            }
            handler = StreamHandlerUtil.adaptToObjectStreamHandler(paramType, arguments[i]);
        }
        if (handler == null) {
            throw new UnsupportedOperationException("We only support operations that have a single stream handler " + method);
        }
        bufHandler.setDaemon(true);
        bufHandler.start();
        while (!bufHandler.isStopped()) {
            Object obj = bufHandler.getNextObject();
            if (obj == null) continue;
            try {
                boolean keepGoing = handler.handle(obj);
                if (keepGoing) continue;
                bufHandler.stop(true);
            }
            catch (RuntimeException e) {
                try {
                    bufHandler.stop(true);
                }
                catch (RuntimeException e2) {
                    LOG.error((Throwable)e2, null, new Object[0]);
                }
                throw e;
            }
        }
        return bufHandler.getResult();
    }

    private static class BufferedResultsHandler
    extends Thread
    implements ObjectStreamHandler {
        private static final Object DONE = new Object();
        private final AtomicBoolean stopped = new AtomicBoolean(false);
        private final Method method;
        private final Object target;
        private final Object[] arguments;
        private final long timeoutMillis;
        private final ArrayBlockingQueue<Object> buffer;
        private Object result = null;

        public BufferedResultsHandler(Method method, Object target, Object[] arguments, int bufferSize, long timeoutMillis) {
            this.method = method;
            this.target = target;
            this.arguments = arguments;
            this.buffer = new ArrayBlockingQueue(bufferSize);
            this.timeoutMillis = timeoutMillis;
        }

        @Override
        public boolean handle(Object obj) {
            if (this.isStopped()) {
                return false;
            }
            Assertions.nullCheck((Object)obj, (String)"obj");
            try {
                this.buffer.put(obj);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ConnectorException.wrap((Throwable)e);
            }
            return !this.isStopped();
        }

        public void stop(boolean wait) {
            if (wait && Thread.currentThread() == this) {
                throw new IllegalStateException("A thread cannot wait on itself");
            }
            if (this.stopped.compareAndSet(false, true)) {
                this.buffer.clear();
                if (wait) {
                    try {
                        this.join(this.timeoutMillis);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ConnectorException.wrap((Throwable)e);
                    }
                    if (this.isAlive()) {
                        throw new OperationTimeoutException();
                    }
                }
            }
        }

        public boolean isStopped() {
            return this.stopped.get();
        }

        private Object[] createActualArguments() {
            Object[] actualArguments = new Object[this.arguments.length];
            Class<?>[] paramTypes = this.method.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> paramType = paramTypes[i];
                actualArguments[i] = StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType) ? StreamHandlerUtil.adaptFromObjectStreamHandler(paramType, this) : this.arguments[i];
            }
            return actualArguments;
        }

        @Override
        public void run() {
            try {
                try {
                    this.result = this.method.invoke(this.target, this.createActualArguments());
                    this.buffer.put(DONE);
                }
                catch (RuntimeException e) {
                    this.buffer.put(e);
                }
                catch (InvocationTargetException e) {
                    this.buffer.put(e.getTargetException());
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.buffer.put(ConnectorException.wrap((Throwable)e));
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e, null, new Object[0]);
            }
        }

        public Object getNextObject() {
            Object obj;
            if (this.isStopped()) {
                return null;
            }
            try {
                obj = this.buffer.poll(this.timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ConnectorException.wrap((Throwable)e);
            }
            if (obj == null) {
                this.stop(false);
                throw new OperationTimeoutException();
            }
            if (obj == DONE) {
                this.stop(true);
                return null;
            }
            if (obj instanceof RuntimeException) {
                this.stop(true);
                throw (RuntimeException)obj;
            }
            if (obj instanceof Error) {
                this.stop(true);
                throw (Error)obj;
            }
            return obj;
        }

        private Object getResult() {
            return this.result;
        }
    }
}

