/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator.jpa;

import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreEntity;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionOperations;

@EnableTransactionManagement(proxyTargetClass=false)
@Order(value=-2147483648)
@Transactional(transactionManager="transactionManagerOidcJwks")
public class OidcJpaJsonWebKeystoreGeneratorService
implements OidcJsonWebKeystoreGeneratorService {
    private final OidcProperties oidcProperties;
    private final TransactionOperations transactionTemplate;
    @PersistenceContext(unitName="oidcJwksEntityManagerFactory")
    private EntityManager entityManager;

    @Override
    public Optional<Resource> find() {
        String issuer = this.oidcProperties.getCore().getIssuer();
        return Optional.ofNullable((OidcJsonWebKeystoreEntity)this.entityManager.find(OidcJsonWebKeystoreEntity.class, (Object)issuer)).map(Unchecked.function(jwks -> OidcJsonWebKeystoreGeneratorService.toResource(new JsonWebKeySet(jwks.getData()))));
    }

    @Override
    public Resource generate() {
        String issuer = this.oidcProperties.getCore().getIssuer();
        return (Resource)Optional.ofNullable((OidcJsonWebKeystoreEntity)this.entityManager.find(OidcJsonWebKeystoreEntity.class, (Object)issuer)).map(Unchecked.function(jwks -> OidcJsonWebKeystoreGeneratorService.toResource(new JsonWebKeySet(jwks.getData())))).orElseGet(Unchecked.supplier(() -> {
            JsonWebKeySet jsonWebKeySet = OidcJsonWebKeystoreGeneratorService.generateJsonWebKeySet(this.oidcProperties);
            return OidcJsonWebKeystoreGeneratorService.toResource(this.store(jsonWebKeySet));
        }));
    }

    @Override
    public JsonWebKeySet store(JsonWebKeySet jsonWebKeySet) throws Exception {
        String issuer = this.oidcProperties.getCore().getIssuer();
        return (JsonWebKeySet)this.transactionTemplate.execute(status -> {
            String result = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
            Optional.ofNullable((OidcJsonWebKeystoreEntity)this.entityManager.find(OidcJsonWebKeystoreEntity.class, (Object)issuer)).ifPresentOrElse(entity -> {
                entity.setData(result);
                this.entityManager.merge(entity);
            }, () -> {
                OidcJsonWebKeystoreEntity entity = new OidcJsonWebKeystoreEntity(issuer, result);
                this.entityManager.persist((Object)entity);
            });
            return jsonWebKeySet;
        });
    }

    @Generated
    public OidcJpaJsonWebKeystoreGeneratorService(OidcProperties oidcProperties, TransactionOperations transactionTemplate) {
        this.oidcProperties = oidcProperties;
        this.transactionTemplate = transactionTemplate;
    }
}

