/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class CasSimpleMultifactorAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler
implements MultifactorAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSimpleMultifactorAuthenticationHandler.class);
    private final CasSimpleMultifactorAuthenticationService multifactorAuthenticationService;
    private final ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider;

    public CasSimpleMultifactorAuthenticationHandler(CasSimpleMultifactorAuthenticationProperties properties, ServicesManager servicesManager, PrincipalFactory principalFactory, CasSimpleMultifactorAuthenticationService mfaService, ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider) {
        super(properties.getName(), servicesManager, principalFactory, Integer.valueOf(properties.getOrder()));
        this.multifactorAuthenticationService = mfaService;
        this.multifactorAuthenticationProvider = multifactorAuthenticationProvider;
    }

    public boolean supports(Credential credential) {
        return CasSimpleMultifactorTokenCredential.class.isAssignableFrom(credential.getClass());
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return CasSimpleMultifactorTokenCredential.class.isAssignableFrom(clazz);
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws GeneralSecurityException {
        try {
            CasSimpleMultifactorTokenCredential tokenCredential = (CasSimpleMultifactorTokenCredential)credential;
            Authentication authentication = WebUtils.getInProgressAuthentication();
            Principal principal = this.multifactorAuthenticationService.validate(authentication, tokenCredential);
            return this.createHandlerResult((Credential)tokenCredential, principal);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new FailedLoginException(e.getMessage());
        }
    }

    @Generated
    public CasSimpleMultifactorAuthenticationService getMultifactorAuthenticationService() {
        return this.multifactorAuthenticationService;
    }

    @Generated
    public ObjectProvider<MultifactorAuthenticationProvider> getMultifactorAuthenticationProvider() {
        return this.multifactorAuthenticationProvider;
    }
}

