/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.HeaderExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.DigestCredentials;

public class DigestAuthExtractor
implements CredentialsExtractor {
    private final HeaderExtractor extractor;

    public DigestAuthExtractor() {
        this("Authorization", "Digest ");
    }

    public DigestAuthExtractor(String headerName, String prefixHeader) {
        this.extractor = new HeaderExtractor(headerName, prefixHeader);
    }

    public Optional<Credentials> extract(WebContext context, SessionStore sessionStore) {
        Optional credentials = this.extractor.extract(context, sessionStore);
        if (!credentials.isPresent()) {
            return Optional.empty();
        }
        String token = ((TokenCredentials)credentials.get()).getToken();
        Map<String, String> valueMap = this.parseTokenValue(token);
        String username = valueMap.get("username");
        String response = valueMap.get("response");
        if (CommonHelper.isBlank((String)username) || CommonHelper.isBlank((String)response)) {
            throw new CredentialsException("Bad format of the digest auth header");
        }
        String realm = valueMap.get("realm");
        String nonce = valueMap.get("nonce");
        String uri = valueMap.get("uri");
        String cnonce = valueMap.get("cnonce");
        String nc = valueMap.get("nc");
        String qop = valueMap.get("qop");
        String method = context.getRequestMethod();
        return Optional.of(new DigestCredentials(response, method, username, realm, nonce, uri, cnonce, nc, qop));
    }

    private Map<String, String> parseTokenValue(String token) {
        StringTokenizer tokenizer = new StringTokenizer(token, ", ");
        HashMap<String, String> map = new HashMap<String, String>();
        while (tokenizer.hasMoreElements()) {
            String keyval = tokenizer.nextToken();
            if (!keyval.contains("=")) continue;
            String key = keyval.substring(0, keyval.indexOf("="));
            String value = keyval.substring(keyval.indexOf("=") + 1);
            map.put(key.trim(), value.replaceAll("\"", "").trim());
        }
        return map;
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), (Object[])new Object[]{"extractor", this.extractor});
    }
}

