/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.data.JEXLItemTransformer;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class JEXLItemTransformerImpl
implements JEXLItemTransformer {
    @Autowired
    private DerAttrHandler derAttrHandler;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    private String propagationJEXL;
    private String pullJEXL;

    public void setPropagationJEXL(String propagationJEXL) {
        this.propagationJEXL = propagationJEXL;
    }

    public void setPullJEXL(String pullJEXL) {
        this.pullJEXL = pullJEXL;
    }

    protected AttrSchemaType beforePropagation(Any<?> any, AttrSchemaType schemaType, PlainAttrValue value) {
        Object oValue;
        MapContext jexlContext = new MapContext();
        if (any != null) {
            JexlUtils.addFieldsToContext(any, (JexlContext)jexlContext);
            JexlUtils.addPlainAttrsToContext((Collection)any.getPlainAttrs(), (JexlContext)jexlContext);
            JexlUtils.addDerAttrsToContext(any, (DerAttrHandler)this.derAttrHandler, (JexlContext)jexlContext);
        }
        switch (schemaType) {
            case Binary: 
            case Encrypted: {
                oValue = value.getBinaryValue();
                break;
            }
            case Boolean: {
                oValue = value.getBooleanValue();
                break;
            }
            case Date: {
                oValue = value.getDateValue();
                break;
            }
            case Double: {
                oValue = value.getDoubleValue();
                break;
            }
            case Long: {
                oValue = value.getLongValue();
                break;
            }
            default: {
                oValue = value.getStringValue();
            }
        }
        jexlContext.set("value", oValue);
        Object tValue = JexlUtils.evaluateExpr((String)this.propagationJEXL, (JexlContext)jexlContext);
        value.setBinaryValue(null);
        value.setBooleanValue(null);
        value.setDateValue(null);
        value.setDoubleValue(null);
        value.setLongValue(null);
        value.setStringValue(null);
        if (tValue instanceof byte[]) {
            value.setBinaryValue((byte[])tValue);
            return AttrSchemaType.Binary;
        }
        if (tValue instanceof Boolean) {
            value.setBooleanValue((Boolean)tValue);
            return AttrSchemaType.Boolean;
        }
        if (tValue instanceof OffsetDateTime) {
            value.setDateValue((OffsetDateTime)tValue);
            return AttrSchemaType.Date;
        }
        if (tValue instanceof Double) {
            value.setDoubleValue((Double)tValue);
            return AttrSchemaType.Double;
        }
        if (tValue instanceof Long) {
            value.setLongValue((Long)tValue);
            return AttrSchemaType.Long;
        }
        if (tValue != null) {
            value.setStringValue(tValue.toString());
        }
        return AttrSchemaType.String;
    }

    public Pair<AttrSchemaType, List<PlainAttrValue>> beforePropagation(Item item, Any<?> any, AttrSchemaType schemaType, List<PlainAttrValue> values) {
        if (StringUtils.isBlank((CharSequence)this.propagationJEXL)) {
            return super.beforePropagation(item, any, schemaType, values);
        }
        AtomicReference<AttrSchemaType> tType = new AtomicReference<AttrSchemaType>();
        if (values.isEmpty()) {
            PlainAttrValue value2 = this.anyUtilsFactory.getInstance(any).newPlainAttrValue();
            tType.set(this.beforePropagation(any, schemaType, value2));
            values.add(value2);
        } else {
            values.forEach(value -> tType.set(this.beforePropagation(any, schemaType, (PlainAttrValue)value)));
        }
        return Pair.of((Object)((AttrSchemaType)tType.get()), values);
    }

    public List<Object> beforePull(Item item, EntityTO entityTO, List<Object> values) {
        if (StringUtils.isNotBlank((CharSequence)this.pullJEXL) && values != null) {
            ArrayList<Object> newValues = new ArrayList<Object>(values.size());
            values.forEach(value -> {
                MapContext jexlContext = new MapContext();
                jexlContext.set("value", value);
                JexlUtils.addFieldsToContext((Object)entityTO, (JexlContext)jexlContext);
                if (entityTO instanceof AnyTO) {
                    JexlUtils.addAttrsToContext((Collection)((AnyTO)entityTO).getPlainAttrs(), (JexlContext)jexlContext);
                    JexlUtils.addAttrsToContext((Collection)((AnyTO)entityTO).getDerAttrs(), (JexlContext)jexlContext);
                    JexlUtils.addAttrsToContext((Collection)((AnyTO)entityTO).getVirAttrs(), (JexlContext)jexlContext);
                }
                newValues.add(JexlUtils.evaluateExpr((String)this.pullJEXL, (JexlContext)jexlContext));
            });
            return newValues;
        }
        return super.beforePull(item, entityTO, values);
    }
}

