/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.SecurityQuestionsModalPanel;
import org.apache.syncope.client.console.rest.SecurityQuestionRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class SecurityQuestionsPanel
extends DirectoryPanel<SecurityQuestionTO, SecurityQuestionTO, SecurityQuestionsProvider, SecurityQuestionRestClient> {
    private static final long serialVersionUID = 3323019773236588850L;

    public SecurityQuestionsPanel(String id, SecurityQuestionRestClient restClient, PageReference pageRef) {
        super(id, new DirectoryPanel.Builder<SecurityQuestionTO, SecurityQuestionTO, SecurityQuestionRestClient>(restClient, pageRef){
            private static final long serialVersionUID = 8769126634538601689L;

            @Override
            protected WizardMgtPanel<SecurityQuestionTO> newInstance(String id, boolean wizardInModal) {
                throw new UnsupportedOperationException();
            }
        }.disableCheckBoxes());
        this.modal.addSubmitButton();
        this.modal.size(Modal.Size.Large);
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.modal.show(false);
            target.add(new Component[]{this.container});
        });
        this.setFooterVisibility(true);
        this.addNewItemPanelBuilder(new AbstractModalPanelBuilder<SecurityQuestionTO>(new SecurityQuestionTO(), pageRef){
            private static final long serialVersionUID = -6388405037134399367L;

            public WizardModalPanel<SecurityQuestionTO> build(String id, int index, AjaxWizard.Mode mode) {
                return new SecurityQuestionsModalPanel(SecurityQuestionsPanel.this.modal, (SecurityQuestionTO)this.newModelObject(), this.pageRef);
            }
        }, true);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"SECURITY_QUESTION_CREATE");
    }

    @Override
    protected SecurityQuestionsProvider dataProvider() {
        return new SecurityQuestionsProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "security.questions.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    @Override
    protected List<IColumn<SecurityQuestionTO, String>> getColumns() {
        ArrayList<IColumn<SecurityQuestionTO, String>> columns = new ArrayList<IColumn<SecurityQuestionTO, String>>();
        columns.add((IColumn<SecurityQuestionTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<SecurityQuestionTO, String>)new PropertyColumn((IModel)new StringResourceModel("content", (Component)this), (Object)"content", "content"));
        return columns;
    }

    @Override
    public ActionsPanel<SecurityQuestionTO> getActions(final IModel<SecurityQuestionTO> model) {
        ActionsPanel<SecurityQuestionTO> panel = super.getActions(model);
        panel.add(new ActionLink<SecurityQuestionTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, SecurityQuestionTO ignore) {
                SecurityQuestionsPanel.this.send((IEventSink)SecurityQuestionsPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((SecurityQuestionTO)model.getObject()), target));
            }
        }, ActionLink.ActionType.EDIT, "SECURITY_QUESTION_UPDATE");
        panel.add(new ActionLink<SecurityQuestionTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, SecurityQuestionTO ignore) {
                try {
                    ((SecurityQuestionRestClient)SecurityQuestionsPanel.this.restClient).delete(((SecurityQuestionTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)SecurityQuestionsPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{SecurityQuestionsPanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", model.getObject(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)SecurityQuestionsPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "SECURITY_QUESTION_DELETE", true);
        return panel;
    }

    protected final class SecurityQuestionsProvider
    extends DirectoryDataProvider<SecurityQuestionTO> {
        private static final long serialVersionUID = -185944053385660794L;
        private final SortableDataProviderComparator<SecurityQuestionTO> comparator;

        private SecurityQuestionsProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator<SecurityQuestionTO>(this);
        }

        public Iterator<SecurityQuestionTO> iterator(long first, long count) {
            List<SecurityQuestionTO> list = ((SecurityQuestionRestClient)SecurityQuestionsPanel.this.restClient).list();
            list.sort(this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((SecurityQuestionRestClient)SecurityQuestionsPanel.this.restClient).list().size();
        }

        public IModel<SecurityQuestionTO> model(SecurityQuestionTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

