/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.RelationId;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractValueHandler;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.StoreException;

public class UntypedPCValueHandler
extends AbstractValueHandler
implements RelationId {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(UntypedPCValueHandler.class);
    private static final UntypedPCValueHandler _instance = new UntypedPCValueHandler();

    public static UntypedPCValueHandler getInstance() {
        return _instance;
    }

    @Override
    @Deprecated
    public Column[] map(ValueMapping vm, String name, ColumnIO io, boolean adapt) {
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn(name, dict != null ? dict.delimitAll() : false);
        return this.map(vm, colName, io, adapt);
    }

    public Column[] map(ValueMapping vm, DBIdentifier name, ColumnIO io, boolean adapt) {
        Column col = new Column();
        col.setIdentifier(name);
        col.setJavaType(9);
        col.setRelationId(true);
        return new Column[]{col};
    }

    @Override
    public boolean isVersionable(ValueMapping vm) {
        return true;
    }

    @Override
    public boolean objectValueRequiresLoad(ValueMapping vm) {
        return true;
    }

    @Override
    public Object toDataStoreValue(ValueMapping vm, Object val, JDBCStore store) {
        PersistenceCapable pc;
        if (ImplHelper.isManageable((Object)val) && (pc = ImplHelper.toPersistenceCapable((Object)val, (Object)store.getConfiguration())).pcGetStateManager() != null) {
            return pc.pcGetStateManager();
        }
        return RelationStrategies.getStateManager(val, store.getContext());
    }

    @Override
    public Object toObjectValue(ValueMapping vm, Object val, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch) throws SQLException {
        if (val == null) {
            return null;
        }
        String str = (String)val;
        int idx = str.indexOf(58);
        if (idx == -1) {
            throw new StoreException(_loc.get("oid-invalid", (Object)str, (Object)vm));
        }
        String clsName = str.substring(0, idx);
        String oidStr = str.substring(idx + 1);
        StoreContext ctx = store.getContext();
        ClassLoader loader = store.getConfiguration().getClassResolverInstance().getClassLoader(vm.getType(), ctx.getClassLoader());
        Class<?> cls = null;
        try {
            cls = Class.forName(clsName, true, loader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new StoreException((Throwable)cnfe);
        }
        Object oid = ctx.newObjectId(cls, (Object)oidStr);
        return store.find(oid, vm, fetch);
    }

    @Override
    public Object toRelationDataStoreValue(OpenJPAStateManager sm, Column col) {
        if (sm == null || sm.getObjectId() == null) {
            return null;
        }
        return sm.getMetaData().getDescribedType().getName() + ":" + sm.getObjectId().toString();
    }
}

