/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.agenda;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.agenda.Agenda;
import org.flowable.common.engine.impl.agenda.AgendaOperationDecorator;
import org.flowable.common.engine.impl.agenda.ExecuteFutureActionOperation;
import org.flowable.common.engine.impl.agenda.WaitForAnyFutureToFinishOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonAgenda
implements Agenda {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AgendaOperationDecorator operationDecorator;
    protected final LinkedList<Runnable> operations = new LinkedList();
    protected final List<ExecuteFutureActionOperation<?>> futureOperations = new ArrayList();

    public CommonAgenda() {
        this(operation -> operation);
    }

    public CommonAgenda(AgendaOperationDecorator operationDecorator) {
        this.operationDecorator = operationDecorator;
    }

    @Override
    public boolean isEmpty() {
        return this.operations.isEmpty() && this.futureOperations.isEmpty();
    }

    @Override
    public Runnable getNextOperation() {
        this.assertOperationsNotEmpty();
        if (!this.operations.isEmpty()) {
            return this.operations.poll();
        }
        ArrayList copyOperations = new ArrayList(this.futureOperations);
        this.futureOperations.clear();
        return new WaitForAnyFutureToFinishOperation(this, copyOperations);
    }

    protected void assertOperationsNotEmpty() {
        if (this.operations.isEmpty() && this.futureOperations.isEmpty()) {
            throw new FlowableException("Unable to peek empty agenda.");
        }
    }

    @Override
    public void planOperation(Runnable operation) {
        Runnable decoratedOperation = this.operationDecorator.decorate(operation);
        this.operations.add(decoratedOperation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Operation {} added to agenda", (Object)operation);
        }
    }

    @Override
    public <V> void planFutureOperation(CompletableFuture<V> future, BiConsumer<V, Throwable> completeAction) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

