/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops;

import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.LeftIndex;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.UnaryCP;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class LeftIndexingOp
extends Hop {
    public static LeftIndexingMethod FORCED_LEFT_INDEXING = null;
    public static String OPSTRING = "lix";
    private boolean _rowLowerEqualsUpper = false;
    private boolean _colLowerEqualsUpper = false;

    private LeftIndexingOp() {
    }

    public LeftIndexingOp(String l, Types.DataType dt, Types.ValueType vt, Hop inpMatrixLeft, Hop inpMatrixRight, Hop inpRowL, Hop inpRowU, Hop inpColL, Hop inpColU, boolean passedRowsLEU, boolean passedColsLEU) {
        super(l, dt, vt);
        this.getInput().add(0, inpMatrixLeft);
        this.getInput().add(1, inpMatrixRight);
        this.getInput().add(2, inpRowL);
        this.getInput().add(3, inpRowU);
        this.getInput().add(4, inpColL);
        this.getInput().add(5, inpColU);
        inpMatrixLeft.getParent().add(this);
        inpMatrixRight.getParent().add(this);
        inpRowL.getParent().add(this);
        inpRowU.getParent().add(this);
        inpColL.getParent().add(this);
        inpColU.getParent().add(this);
        this.setRowLowerEqualsUpper(passedRowsLEU);
        this.setColLowerEqualsUpper(passedColsLEU);
    }

    @Override
    public void checkArity() {
        HopsException.check(this._input.size() == 6, this, "should have 6 inputs but has %d inputs", 6);
    }

    public boolean isRowLowerEqualsUpper() {
        return this._rowLowerEqualsUpper;
    }

    public boolean isColLowerEqualsUpper() {
        return this._colLowerEqualsUpper;
    }

    public void setRowLowerEqualsUpper(boolean passed) {
        this._rowLowerEqualsUpper = passed;
    }

    public void setColLowerEqualsUpper(boolean passed) {
        this._colLowerEqualsUpper = passed;
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            Types.ExecType et = this.optFindExecType();
            if (et == Types.ExecType.SPARK) {
                Hop left = this.getInput().get(0);
                Hop right = this.getInput().get(1);
                LeftIndexingMethod method = LeftIndexingOp.getOptMethodLeftIndexingMethod(left.getDim1(), left.getDim2(), left.getBlocksize(), left.getNnz(), right.getDim1(), right.getDim2(), right.getNnz(), right.getDataType());
                Lop rightInput = right.constructLops();
                if (this.isRightHandSideScalar()) {
                    rightInput = new UnaryCP(rightInput, left.getDataType() == Types.DataType.MATRIX ? Types.OpOp1.CAST_AS_MATRIX : Types.OpOp1.CAST_AS_FRAME, left.getDataType(), right.getValueType());
                    long bsize = ConfigurationManager.getBlocksize();
                    rightInput.getOutputParameters().setDimensions(1L, 1L, bsize, -1L);
                }
                LeftIndex leftIndexLop = new LeftIndex(left.constructLops(), rightInput, this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getInput().get(4).constructLops(), this.getInput().get(5).constructLops(), this.getDataType(), this.getValueType(), et, LeftIndexingOp.getSpLixCacheType(method));
                this.setOutputDimensions(leftIndexLop);
                this.setLineNumbers(leftIndexLop);
                this.setLops(leftIndexLop);
            } else {
                LeftIndex left = new LeftIndex(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getInput().get(4).constructLops(), this.getInput().get(5).constructLops(), this.getDataType(), this.getValueType(), et);
                this.setOutputDimensions(left);
                this.setLineNumbers(left);
                this.setLops(left);
            }
        }
        catch (Exception e) {
            throw new HopsException(this.printErrorLocation() + "In LeftIndexingOp Hop, error in constructing Lops ", e);
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    private boolean isRightHandSideScalar() {
        Hop rightHandSide = this.getInput().get(1);
        return rightHandSide.getDataType() == Types.DataType.SCALAR;
    }

    private static LeftIndex.LixCacheType getSpLixCacheType(LeftIndexingMethod method) {
        switch (method) {
            case SP_MLEFTINDEX_L: {
                return LeftIndex.LixCacheType.LEFT;
            }
            case SP_MLEFTINDEX_R: {
                return LeftIndex.LixCacheType.RIGHT;
            }
        }
        return LeftIndex.LixCacheType.NONE;
    }

    @Override
    public String getOpString() {
        String s = new String("");
        s = s + OPSTRING;
        return s;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    public void computeMemEstimate(MemoTable memo) {
        super.computeMemEstimate(memo);
        Hop rhM = this.getInput().get(1);
        DataCharacteristics dcRhM = memo.getAllInputStats(rhM);
        if (this.dimsKnown() && !rhM.dimsKnown() && !dcRhM.dimsKnown()) {
            double subSize = -1.0;
            subSize = this._rowLowerEqualsUpper && this._colLowerEqualsUpper ? (double)OptimizerUtils.estimateSize(1L, 1L) : (this._rowLowerEqualsUpper ? (double)OptimizerUtils.estimateSize(1L, this.getDim2()) : (this._colLowerEqualsUpper ? (double)OptimizerUtils.estimateSize(this.getDim1(), 1L) : this._outputMemEstimate));
            this._memEstimate = this.getInputSize(0) + subSize + this._outputMemEstimate;
        } else if (this.dimsKnown() && this.getNnz() < 0L && this._memEstimate >= OptimizerUtils.DEFAULT_SIZE) {
            DataCharacteristics dcM1 = memo.getAllInputStats(this.getInput().get(0));
            DataCharacteristics dcM2 = memo.getAllInputStats(this.getInput().get(1));
            if (dcM1.getNonZeros() >= 0L && dcM2.getNonZeros() >= 0L && this.hasConstantIndexingRange()) {
                long lnnz = dcM1.getNonZeros() + dcM2.getNonZeros();
                this._outputMemEstimate = this.computeOutputMemEstimate(this.getDim1(), this.getDim2(), lnnz);
                this._memEstimate = this.getInputSize(0) + this.getInputSize(1) + this._outputMemEstimate;
            }
        }
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double sparsity = 1.0;
        if (nnz < 0L) {
            Hop input1 = this.getInput().get(0);
            Hop input2 = this.getInput().get(1);
            if (input1.dimsKnown() && this.hasConstantIndexingRange()) {
                sparsity = OptimizerUtils.getLeftIndexingSparsity(input1.getDim1(), input1.getDim2(), input1.getNnz(), input2.getDim1(), input2.getDim2(), input2.getNnz());
            }
        } else {
            sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
        }
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected DataCharacteristics inferOutputCharacteristics(MemoTable memo) {
        MatrixCharacteristics ret = null;
        Hop input1 = this.getInput().get(0);
        Hop input2 = this.getInput().get(1);
        DataCharacteristics dc1 = memo.getAllInputStats(input1);
        DataCharacteristics dc2 = memo.getAllInputStats(input2);
        if (dc1.dimsKnown()) {
            double sparsity = OptimizerUtils.getLeftIndexingSparsity(dc1.getRows(), dc1.getCols(), dc1.getNonZeros(), dc2.getRows(), dc2.getCols(), dc2.getNonZeros());
            long lnnz = !this.hasConstantIndexingRange() ? -1L : (long)(sparsity * (double)dc1.getRows() * (double)dc1.getCols());
            ret = new MatrixCharacteristics(dc1.getRows(), dc1.getCols(), -1, lnnz);
        }
        return ret;
    }

    @Override
    protected Types.ExecType optFindExecType() {
        this.checkAndSetForcedPlatform();
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            if (OptimizerUtils.isMemoryBasedOptLevel()) {
                this._etype = this.findExecTypeByMemEstimate();
                this.checkAndModifyRecompilationStatus();
            } else {
                this._etype = this.getInput().get(0).areDimsBelowThreshold() ? Types.ExecType.CP : Types.ExecType.SPARK;
            }
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (this.getInput().get(0).getDataType() == Types.DataType.LIST) {
            this._etype = Types.ExecType.CP;
        }
        this.setRequiresRecompileIfNecessary();
        return this._etype;
    }

    private static LeftIndexingMethod getOptMethodLeftIndexingMethod(long m1_dim1, long m1_dim2, long m1_blen, long m1_nnz, long m2_dim1, long m2_dim2, long m2_nnz, Types.DataType rhsDt) {
        if (FORCED_LEFT_INDEXING != null) {
            return FORCED_LEFT_INDEXING;
        }
        if (rhsDt == Types.DataType.SCALAR) {
            return LeftIndexingMethod.SP_MLEFTINDEX_R;
        }
        if (m2_dim1 >= 1L && m2_dim2 >= 1L && m2_dim1 >= 1L && m2_dim2 >= 1L) {
            boolean isAligned = rhsDt == Types.DataType.MATRIX && (m1_dim1 == m2_dim1 && m1_dim2 <= m1_blen || m1_dim2 == m2_dim2 && m1_dim1 <= m1_blen);
            boolean broadcastRhs = OptimizerUtils.checkSparkBroadcastMemoryBudget(m2_dim1, m2_dim2, m1_blen, m2_nnz);
            double m1SizeP = OptimizerUtils.estimatePartitionedSizeExactSparsity(m1_dim1, m1_dim2, m1_blen, m1_nnz);
            double m2SizeP = OptimizerUtils.estimatePartitionedSizeExactSparsity(m2_dim1, m2_dim2, m1_blen, m2_nnz);
            if (broadcastRhs) {
                if (isAligned && m1SizeP < m2SizeP) {
                    return LeftIndexingMethod.SP_MLEFTINDEX_L;
                }
                return LeftIndexingMethod.SP_MLEFTINDEX_R;
            }
        }
        return LeftIndexingMethod.SP_GLEFTINDEX;
    }

    @Override
    public void refreshSizeInformation() {
        Hop input1 = this.getInput().get(0);
        Hop input2 = this.getInput().get(1);
        this.setDim1(input1.getDim1());
        this.setDim2(input1.getDim2());
        if (input1.getNnz() == 0L && this.hasConstantIndexingRange()) {
            if (input2.getDataType() == Types.DataType.SCALAR) {
                this.setNnz(1L);
            } else {
                this.setNnz(input2.getNnz());
            }
        } else {
            this.setNnz(-1L);
        }
    }

    private boolean hasConstantIndexingRange() {
        return this.getInput().get(2) instanceof LiteralOp && this.getInput().get(3) instanceof LiteralOp && this.getInput().get(4) instanceof LiteralOp && this.getInput().get(5) instanceof LiteralOp;
    }

    private void checkAndModifyRecompilationStatus() {
        if (this._etype == Types.ExecType.CP) {
            this._requiresRecompile = false;
            Hop rInput = this.getInput().get(1);
            if (!rInput.dimsKnown() && rInput instanceof DataOp) {
                ((DataOp)rInput).disableRecompileRead();
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LeftIndexingOp ret = new LeftIndexingOp();
        ret.clone(this, false);
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof LeftIndexingOp) || this.getInput().size() != that.getInput().size()) {
            return false;
        }
        return this.getInput().get(0) == that.getInput().get(0) && this.getInput().get(1) == that.getInput().get(1) && this.getInput().get(2) == that.getInput().get(2) && this.getInput().get(3) == that.getInput().get(3) && this.getInput().get(4) == that.getInput().get(4) && this.getInput().get(5) == that.getInput().get(5);
    }

    public static enum LeftIndexingMethod {
        SP_GLEFTINDEX,
        SP_MLEFTINDEX_R,
        SP_MLEFTINDEX_L;

    }
}

