/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.DoubleIdentifier;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.parser.IntIdentifier;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.VariableSet;
import org.apache.sysds.parser.WhileStatementBlock;
import org.apache.sysds.runtime.util.ProgramConverter;

public class FunctionStatementBlock
extends StatementBlock
implements Types.FunctionBlock {
    private boolean _recompileOnce = false;
    private boolean _nondeterministic = false;

    @Override
    public VariableSet validate(DMLProgram dmlProg, VariableSet ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        if (this._statements.size() > 1) {
            throw new LanguageException(this.printBlockErrorLocation() + "FunctionStatementBlock should have only 1 statement (FunctionStatement)");
        }
        FunctionStatement fstmt = (FunctionStatement)this._statements.get(0);
        ArrayList<DataIdentifier> inputValues = fstmt.getInputParams();
        for (DataIdentifier inputValue : inputValues) {
            if (inputValue.getDataType() != Types.DataType.MATRIX || inputValue.getValueType() == Types.ValueType.FP64) continue;
            this.raiseValidateError("for function " + fstmt.getName() + ", input variable " + inputValue.getName() + " has an unsupported value type of " + (Object)((Object)inputValue.getValueType()) + ".", false);
        }
        this._dmlProg = dmlProg;
        for (StatementBlock sb : fstmt.getBody()) {
            ids = sb.validate(dmlProg, ids, constVars, conditional);
            constVars = sb.getConstOut();
        }
        if (fstmt.getBody().size() > 0) {
            this._constVarsIn.putAll(fstmt.getBody().get(0).getConstIn());
        }
        if (fstmt.getBody().size() > 1) {
            this._constVarsOut.putAll(fstmt.getBody().get(fstmt.getBody().size() - 1).getConstOut());
        }
        ArrayList<DataIdentifier> returnValues = fstmt.getOutputParams();
        for (DataIdentifier returnValue : returnValues) {
            DataIdentifier curr = ids.getVariable(returnValue.getName());
            if (curr == null) {
                this.raiseValidateError("for function " + fstmt.getName() + ", return variable " + returnValue.getName() + " must be defined in function ", conditional);
            }
            if (curr.getDataType() != Types.DataType.UNKNOWN && !curr.getDataType().equals((Object)returnValue.getDataType())) {
                this.raiseValidateError("for function " + fstmt.getName() + ", return variable " + curr.getName() + " data type of " + (Object)((Object)curr.getDataType()) + " does not match data type in function signature of " + (Object)((Object)returnValue.getDataType()), conditional);
            }
            if (curr.getValueType() == Types.ValueType.UNKNOWN || returnValue.getValueType() == Types.ValueType.UNKNOWN || curr.getValueType().equals((Object)returnValue.getValueType())) continue;
            if (curr.getDataType() == Types.DataType.SCALAR && returnValue.getDataType() == Types.DataType.SCALAR) {
                if (returnValue.getValueType() == Types.ValueType.FP64) {
                    if (curr.getValueType() == Types.ValueType.INT64) {
                        IntIdentifier currIntValue = (IntIdentifier)constVars.get(curr.getName());
                        if (currIntValue != null) {
                            DoubleIdentifier currDoubleValue = new DoubleIdentifier(currIntValue.getValue(), (ParseInfo)curr);
                            constVars.put(curr.getName(), currDoubleValue);
                        }
                        LOG.warn((Object)(curr.printWarningLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " but was safely cast"));
                        curr.setValueType(Types.ValueType.FP64);
                        ids.addVariable(curr.getName(), curr);
                    } else {
                        throw new LanguageException(curr.printErrorLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " and cannot safely cast value");
                    }
                }
                if (returnValue.getValueType() != Types.ValueType.INT64) continue;
                throw new LanguageException(curr.printErrorLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " and cannot safely cast " + (Object)((Object)curr.getValueType()) + " as " + (Object)((Object)returnValue.getValueType()));
            }
            throw new LanguageException(curr.printErrorLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " and cannot safely cast " + (Object)((Object)curr.getValueType()) + " as " + (Object)((Object)returnValue.getValueType()));
        }
        return ids;
    }

    public FunctionOp.FunctionType getFunctionOpType() {
        return FunctionOp.FunctionType.DML;
    }

    @Override
    public VariableSet initializeforwardLV(VariableSet activeInPassed) {
        FunctionStatement fstmt = (FunctionStatement)this._statements.get(0);
        if (this._statements.size() > 1) {
            throw new LanguageException(this.printBlockErrorLocation() + "FunctionStatementBlock should have only 1 statement (while statement)");
        }
        this._read = new VariableSet();
        this._gen = new VariableSet();
        VariableSet current = new VariableSet();
        current.addVariables(activeInPassed);
        for (StatementBlock sb : fstmt.getBody()) {
            current = sb.initializeforwardLV(current);
            for (String varName : sb._gen.getVariableNames()) {
                if (this._kill.getVariableNames().contains(varName)) continue;
                this._gen.addVariable(varName, sb._gen.getVariable(varName));
            }
            this._read.addVariables(sb._read);
            this._updated.addVariables(sb._updated);
            if (sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) continue;
            this._kill.addVariables(sb._kill);
        }
        this._liveOut = new VariableSet();
        this._liveOut.addVariables(current);
        this._liveOut.addVariables(this._updated);
        return this._liveOut;
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet loPassed) {
        FunctionStatement wstmt = (FunctionStatement)this._statements.get(0);
        VariableSet lo = new VariableSet();
        lo.addVariables(loPassed);
        int numBlocks = wstmt.getBody().size();
        for (int i = numBlocks - 1; i >= 0; --i) {
            lo = wstmt.getBody().get(i).analyze(lo);
        }
        VariableSet loReturn = new VariableSet();
        loReturn.addVariables(lo);
        return loReturn;
    }

    @Override
    public VariableSet analyze(VariableSet loPassed) {
        throw new LanguageException(this.printBlockErrorLocation() + "Both liveIn and liveOut variables need to be specified for liveness analysis for FunctionStatementBlock");
    }

    public VariableSet analyze(VariableSet liPassed, VariableSet loPassed) {
        VariableSet candidateLO = new VariableSet();
        candidateLO.addVariables(loPassed);
        candidateLO.addVariables(this._gen);
        VariableSet origLiveOut = new VariableSet();
        origLiveOut.addVariables(this._liveOut);
        this._liveOut = new VariableSet();
        for (String name : candidateLO.getVariableNames()) {
            if (!origLiveOut.containsVariable(name)) continue;
            this._liveOut.addVariable(name, candidateLO.getVariable(name));
        }
        this.initializebackwardLV(this._liveOut);
        this._liveIn = new VariableSet();
        this._liveIn.addVariables(liPassed);
        VariableSet liveInReturn = new VariableSet();
        liveInReturn.addVariables(this._liveIn);
        return liveInReturn;
    }

    public void setRecompileOnce(boolean flag) {
        this._recompileOnce = flag;
    }

    public boolean isRecompileOnce() {
        return this._recompileOnce;
    }

    @Override
    public void setNondeterministic(boolean flag) {
        this._nondeterministic = flag;
    }

    @Override
    public boolean isNondeterministic() {
        return this._nondeterministic;
    }

    @Override
    public Types.FunctionBlock cloneFunctionBlock() {
        return ProgramConverter.createDeepCopyFunctionStatementBlock(this, new HashSet<String>(), new HashSet<String>());
    }
}

