/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupConst
extends ColGroupValue {
    private static final long serialVersionUID = 3204391661346504L;

    protected ColGroupConst(int numRows) {
        super(numRows);
    }

    public ColGroupConst(int[] colIndices, int numRows, ADictionary dict) {
        super(colIndices, numRows, dict, null);
    }

    @Override
    public int[] getCounts(int[] out) {
        out[0] = this._numRows;
        return out;
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] out) {
        out[0] = ru - rl;
        return out;
    }

    @Override
    protected void computeRowSums(double[] c, boolean square, int rl, int ru) {
        double vals = this._dict.sumAllRowsToDouble(square, this._colIndexes.length)[0];
        int rix = rl;
        while (rix < ru) {
            int n = rix++;
            c[n] = c[n] + vals;
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        double value = this._dict.aggregateTuples(builtin, this._colIndexes.length)[0];
        for (int i = rl; i < ru; ++i) {
            c[i] = builtin.execute(c[i], value);
        }
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.CONST;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.CONST;
    }

    @Override
    protected void decompressToBlockUnSafeDenseDictionary(MatrixBlock target, int rl, int ru, int offT, double[] values) {
        double[] c = target.getDenseBlockValues();
        offT *= target.getNumColumns();
        int i = rl;
        while (i < ru) {
            for (int j = 0; j < this._colIndexes.length; ++j) {
                int n = offT + this._colIndexes[j];
                c[n] = c[n] + values[j];
            }
            ++i;
            offT += target.getNumColumns();
        }
    }

    @Override
    protected void decompressToBlockUnSafeSparseDictionary(MatrixBlock target, int rl, int ru, int offT, SparseBlock values) {
        throw new NotImplementedException();
    }

    @Override
    public double get(int r, int c) {
        return this._dict.getValue(Arrays.binarySearch(this._colIndexes, c));
    }

    @Override
    protected void preAggregate(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        if (m.isInSparseFormat()) {
            this.preAggregateSparse(m.getSparseBlock(), preAgg, rl, ru);
        } else {
            this.preAggregateDense(m, preAgg, rl, ru);
        }
    }

    private void preAggregateDense(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        double[] mV = m.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            int rc = 0;
            int offLeft = rowLeft * this._numRows;
            while (rc < this._numRows) {
                int n = offOut;
                preAV[n] = preAV[n] + mV[offLeft];
                ++rc;
                ++offLeft;
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    private void preAggregateSparse(SparseBlock sb, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            if (!sb.isEmpty(rowLeft)) {
                int apos = sb.pos(rowLeft);
                int alen = sb.size(rowLeft) + apos;
                double[] avals = sb.values(rowLeft);
                for (int j = apos; j < alen; ++j) {
                    int n = offOut;
                    preAV[n] = preAV[n] + avals[j];
                }
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        return new ColGroupConst(this._colIndexes, this._numRows, this.applyScalarOp(op));
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        return new ColGroupConst(this._colIndexes, this._numRows, this.applyBinaryRowOp(op, v, true, left));
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int i;
        double[] values = this._dict.getValues();
        int base = 0;
        for (i = 0; i < values.length; ++i) {
            base += values[i] == 0.0 ? 0 : 1;
        }
        for (i = 0; i < ru - rl; ++i) {
            rnnz[i] = base;
        }
    }

    @Override
    protected boolean sameIndexStructure(ColGroupCompressed that) {
        return that instanceof ColGroupEmpty || that instanceof ColGroupConst;
    }
}

