/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuaternaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class QuaternaryWSigmoidFEDInstruction
extends QuaternaryFEDInstruction {
    protected QuaternaryWSigmoidFEDInstruction(Operator operator, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String instruction_str) {
        super(FEDInstruction.FEDType.Quaternary, operator, in1, in2, in3, out, opcode, instruction_str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject X = ec.getMatrixObject(this.input1);
        MatrixObject U = ec.getMatrixObject(this.input2);
        MatrixObject V = ec.getMatrixObject(this.input3);
        if (!X.isFederated(FederationMap.FType.ROW) || U.isFederated() || V.isFederated()) {
            throw new DMLRuntimeException("Unsupported federated inputs (X, U, V) = (" + X.isFederated() + ", " + U.isFederated() + ", " + V.isFederated() + ")");
        }
        FederationMap fedMap = X.getFedMapping();
        FederatedRequest[] frInit1 = fedMap.broadcastSliced(U, false);
        FederatedRequest frInit2 = fedMap.broadcast(V);
        FederatedRequest frCompute1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3}, new long[]{fedMap.getID(), frInit1[0].getID(), frInit2.getID()});
        FederatedRequest frGet1 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, frCompute1.getID());
        FederatedRequest frCleanup1 = fedMap.cleanup(this.getTID(), frCompute1.getID());
        FederatedRequest frCleanup2 = fedMap.cleanup(this.getTID(), frInit1[0].getID());
        FederatedRequest frCleanup3 = fedMap.cleanup(this.getTID(), frInit2.getID());
        Future<FederatedResponse>[] response = fedMap.execute(this.getTID(), true, frInit1, new FederatedRequest[]{frInit2, frCompute1, frGet1, frCleanup1, frCleanup2, frCleanup3});
        ec.setMatrixOutput(this.output.getName(), FederationUtils.bind(response, false));
    }
}

