/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client.util;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.spark_project.jetty.client.api.Authentication;
import org.spark_project.jetty.client.api.ContentResponse;
import org.spark_project.jetty.client.api.Request;
import org.spark_project.jetty.client.util.AbstractAuthentication;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.util.Attributes;
import org.spark_project.jetty.util.B64Code;

public class BasicAuthentication
extends AbstractAuthentication {
    private final String user;
    private final String password;

    public BasicAuthentication(URI uri, String realm, String user, String password) {
        super(uri, realm);
        this.user = user;
        this.password = password;
    }

    @Override
    public String getType() {
        return "Basic";
    }

    @Override
    public Authentication.Result authenticate(Request request, ContentResponse response, Authentication.HeaderInfo headerInfo, Attributes context) {
        String value2 = "Basic " + B64Code.encode(this.user + ":" + this.password, StandardCharsets.ISO_8859_1);
        return new BasicResult(headerInfo.getHeader(), value2);
    }

    private class BasicResult
    implements Authentication.Result {
        private final HttpHeader header;
        private final String value;

        public BasicResult(HttpHeader header, String value2) {
            this.header = header;
            this.value = value2;
        }

        @Override
        public URI getURI() {
            return BasicAuthentication.this.getURI();
        }

        @Override
        public void apply(Request request) {
            request.header(this.header, this.value);
        }

        public String toString() {
            return String.format("Basic authentication result for %s", this.getURI());
        }
    }
}

