/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;

public class GroupedAggregate
extends Lop {
    private HashMap<String, Lop> _inputParams;
    private static final String opcode = "groupedagg";
    public static final String COMBINEDINPUT = "combinedinput";
    private boolean _broadcastGroups = false;
    private int _numThreads = 1;

    public GroupedAggregate(HashMap<String, Lop> inputParameterLops, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        super(Lop.Type.GroupedAgg, dt, vt);
        this.init(inputParameterLops, dt, vt, et);
    }

    public GroupedAggregate(HashMap<String, Lop> inputParameterLops, Types.DataType dt, Types.ValueType vt, Types.ExecType et, boolean broadcastGroups) {
        super(Lop.Type.GroupedAgg, dt, vt);
        this.init(inputParameterLops, dt, vt, et);
        this._broadcastGroups = broadcastGroups;
    }

    public GroupedAggregate(HashMap<String, Lop> inputParameterLops, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int k) {
        super(Lop.Type.GroupedAgg, dt, vt);
        this.init(inputParameterLops, dt, vt, et);
        this._numThreads = k;
    }

    private void init(HashMap<String, Lop> inputParameterLops, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this.addInput(inputParameterLops.get("target"));
        inputParameterLops.get("target").addOutput(this);
        this.addInput(inputParameterLops.get("groups"));
        inputParameterLops.get("groups").addOutput(this);
        for (Map.Entry<String, Lop> e : inputParameterLops.entrySet()) {
            String k = e.getKey();
            Lop lop = e.getValue();
            if (k.equalsIgnoreCase("target") || k.equalsIgnoreCase("groups")) continue;
            this.addInput(lop);
            lop.addOutput(this);
        }
        this._inputParams = inputParameterLops;
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation = GroupedAggregate";
    }

    @Override
    public String getInstructions(String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(opcode);
        sb.append("\u00b0");
        if (this._inputParams.get("target") == null || this._inputParams.get("groups") == null || this._inputParams.get("fn") == null) {
            throw new LopsException(this.printErrorLocation() + "Invalid parameters to groupedAggregate -- \"target\", \"groups\", \"fn\" must be provided");
        }
        String targetVar = this._inputParams.get("target").getOutputParameters().getLabel();
        String groupsVar = this._inputParams.get("groups").getOutputParameters().getLabel();
        sb.append("target");
        sb.append("=");
        sb.append(targetVar);
        sb.append("\u00b0");
        sb.append("groups");
        sb.append("=");
        sb.append(groupsVar);
        if (this._inputParams.get("weights") != null) {
            sb.append("\u00b0");
            sb.append("weights");
            sb.append("=");
            sb.append(this._inputParams.get("weights").getOutputParameters().getLabel());
        }
        for (Map.Entry<String, Lop> e : this._inputParams.entrySet()) {
            String name = e.getKey();
            if (name.equalsIgnoreCase("target") || name.equalsIgnoreCase("groups") || name.equalsIgnoreCase("weights")) continue;
            Lop value = e.getValue();
            String valueString = value.prepScalarLabel();
            sb.append("\u00b0");
            sb.append(name);
            sb.append("=");
            sb.append(valueString);
        }
        if (this.getExecType() == Types.ExecType.CP) {
            sb.append("\u00b0");
            sb.append("k");
            sb.append("=");
            sb.append(this._numThreads);
        } else if (this.getExecType() == Types.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append("broadcast");
            sb.append("=");
            sb.append(this._broadcastGroups);
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }
}

