/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToCharPByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToInt;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public interface MapToFactory {
    public static final Log LOG = LogFactory.getLog((String)MapToFactory.class.getName());

    public static AMapToData create(int size, ABitmap ubm) {
        if (ubm == null) {
            return null;
        }
        return MapToFactory.create(size, ubm.containsZero(), ubm.getOffsetList());
    }

    public static AMapToData create(int size, boolean zeros, IntArrayList[] values) {
        AMapToData _data = MapToFactory.create(size, values.length + (zeros ? 1 : 0));
        if (zeros) {
            _data.fill(values.length);
        }
        for (int i = 0; i < values.length; ++i) {
            IntArrayList tmpList = values[i];
            int sz = tmpList.size();
            for (int k = 0; k < sz; ++k) {
                _data.set(tmpList.get(k), i);
            }
        }
        return _data;
    }

    public static AMapToData create(int size, int[] values, int nUnique) {
        AMapToData _data = MapToFactory.create(size, nUnique);
        _data.copyInt(values);
        return _data;
    }

    public static AMapToData create(int size, int numTuples) {
        if (numTuples <= 1) {
            return new MapToZero(size);
        }
        if (numTuples == 2 && size > 32) {
            return new MapToBit(numTuples, size);
        }
        if (numTuples <= 127) {
            return new MapToUByte(numTuples, size);
        }
        if (numTuples <= 256) {
            return new MapToByte(numTuples, size);
        }
        if (numTuples <= 65536) {
            return new MapToChar(numTuples, size);
        }
        if (numTuples <= 8322945) {
            return new MapToCharPByte(numTuples, size);
        }
        return new MapToInt(numTuples, size);
    }

    public static AMapToData create(int size, MAP_TYPE t) {
        switch (t) {
            case ZERO: {
                return new MapToZero(size);
            }
            case BIT: {
                return new MapToBit(size);
            }
            case UBYTE: {
                return new MapToUByte(size);
            }
            case BYTE: {
                return new MapToByte(size);
            }
            case CHAR: {
                return new MapToChar(size);
            }
            case CHAR_BYTE: {
                return new MapToCharPByte(size);
            }
            case INT: {
                return new MapToInt(size);
            }
        }
        throw new DMLCompressionException("Unsupported type " + t);
    }

    public static AMapToData resize(AMapToData d, int numTuples) {
        return d.resize(numTuples);
    }

    public static AMapToData resizeForce(AMapToData d, MAP_TYPE t) {
        AMapToData ret;
        int size = d.size();
        int numTuples = d.getUnique();
        switch (t) {
            case ZERO: {
                return new MapToZero(size);
            }
            case BIT: {
                ret = new MapToBit(numTuples, size);
                break;
            }
            case UBYTE: {
                ret = new MapToUByte(numTuples, size);
                break;
            }
            case BYTE: {
                ret = new MapToByte(numTuples, size);
                break;
            }
            case CHAR: {
                ret = new MapToChar(numTuples, size);
                break;
            }
            case CHAR_BYTE: {
                ret = new MapToCharPByte(numTuples, size);
                break;
            }
            case INT: {
                ret = new MapToInt(numTuples, size);
                break;
            }
            default: {
                throw new DMLCompressionException("Unsupported type of map " + t);
            }
        }
        ret.copy(d);
        return ret;
    }

    public static long estimateInMemorySize(int size, int numTuples) {
        if (numTuples <= 1) {
            return MapToZero.getInMemorySize(size);
        }
        if (numTuples == 2 && size > 32) {
            return MapToBit.getInMemorySize(size);
        }
        if (numTuples <= 256) {
            return MapToByte.getInMemorySize(size);
        }
        if (numTuples <= 65536) {
            return MapToChar.getInMemorySize(size);
        }
        if (numTuples <= 8322945) {
            return MapToCharPByte.getInMemorySize(size);
        }
        return MapToInt.getInMemorySize(size);
    }

    public static AMapToData readIn(DataInput in) throws IOException {
        MAP_TYPE t = MAP_TYPE.values()[in.readByte()];
        switch (t) {
            case ZERO: {
                return MapToZero.readFields(in);
            }
            case BIT: {
                return MapToBit.readFields(in);
            }
            case UBYTE: {
                return MapToUByte.readFields(in);
            }
            case BYTE: {
                return MapToByte.readFields(in);
            }
            case CHAR: {
                return MapToChar.readFields(in);
            }
            case CHAR_BYTE: {
                return MapToCharPByte.readFields(in);
            }
            case INT: {
                return MapToInt.readFields(in);
            }
        }
        throw new DMLCompressionException("unsupported type " + t);
    }

    public static enum MAP_TYPE {
        ZERO,
        BIT,
        UBYTE,
        BYTE,
        CHAR,
        CHAR_BYTE,
        INT;

    }
}

