/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstructionUtils;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.utils.Explain;

public class DMLOptions {
    public final Options options;
    public Map<String, String> argVals = new HashMap<String, String>();
    public String configFile = null;
    public boolean clean = false;
    public boolean stats = false;
    public int statsCount = 10;
    public boolean fedStats = false;
    public int fedStatsCount = 10;
    public boolean memStats = false;
    public Explain.ExplainType explainType = Explain.ExplainType.NONE;
    public Types.ExecMode execMode = OptimizerUtils.getDefaultExecutionMode();
    public boolean gpu = false;
    public boolean forceGPU = false;
    public boolean debug = false;
    public String filePath = null;
    public String script = null;
    public boolean help = false;
    public boolean lineage = false;
    public boolean lineage_dedup = false;
    public LineageCacheConfig.ReuseCacheType linReuseType = LineageCacheConfig.ReuseCacheType.NONE;
    public LineageCacheConfig.LineageCachePolicy linCachePolicy = LineageCacheConfig.LineageCachePolicy.COSTNSIZE;
    public boolean lineage_estimate = false;
    public boolean lineage_debugger = false;
    public boolean fedWorker = false;
    public int fedWorkerPort = -1;
    public boolean fedMonitoring = false;
    public int fedMonitoringPort = -1;
    public int pythonPort = -1;
    public boolean checkPrivacy = false;
    public boolean federatedCompilation = false;
    public boolean noFedRuntimeConversion = false;
    public int seed = -1;
    public static final DMLOptions defaultOptions = new DMLOptions(null);

    public DMLOptions(Options opts) {
        this.options = opts;
    }

    public String toString() {
        return "DMLOptions{argVals=" + this.argVals + ", configFile='" + this.configFile + "', clean=" + this.clean + ", stats=" + this.stats + ", statsCount=" + this.statsCount + ", fedStats=" + this.fedStats + ", fedStatsCount=" + this.fedStatsCount + ", fedMonitor=" + this.fedMonitoring + ", memStats=" + this.memStats + ", explainType=" + this.explainType + ", execMode=" + this.execMode + ", gpu=" + this.gpu + ", forceGPU=" + this.forceGPU + ", debug=" + this.debug + ", filePath='" + this.filePath + "', script='" + this.script + "', help=" + this.help + ", lineage=" + this.lineage + ", w=" + this.fedWorker + ", federatedCompilation=" + this.federatedCompilation + ", noFedRuntimeConversion=" + this.noFedRuntimeConversion + ", seed=" + this.seed + "}";
    }

    public static DMLOptions parseCLArguments(String[] args) throws ParseException {
        String fedStatsCount;
        String statsCount;
        String execMode;
        String force;
        Options options = DMLOptions.createCLIOptions();
        PosixParser clParser = new PosixParser();
        CommandLine line = clParser.parse(options, args);
        DMLOptions dmlOptions = new DMLOptions(options);
        dmlOptions.help = line.hasOption("help");
        if (line.hasOption("lineage")) {
            dmlOptions.lineage = true;
            String[] lineageTypes = line.getOptionValues("lineage");
            if (lineageTypes != null) {
                for (String lineageType : lineageTypes) {
                    if (lineageType == null) continue;
                    if (lineageType.equalsIgnoreCase("dedup")) {
                        dmlOptions.lineage_dedup = lineageType.equalsIgnoreCase("dedup");
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("reuse_full") || lineageType.equalsIgnoreCase("reuse")) {
                        dmlOptions.linReuseType = LineageCacheConfig.ReuseCacheType.REUSE_FULL;
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("reuse_partial")) {
                        dmlOptions.linReuseType = LineageCacheConfig.ReuseCacheType.REUSE_PARTIAL;
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("reuse_multilevel")) {
                        dmlOptions.linReuseType = LineageCacheConfig.ReuseCacheType.REUSE_MULTILEVEL;
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("reuse_hybrid")) {
                        dmlOptions.linReuseType = LineageCacheConfig.ReuseCacheType.REUSE_HYBRID;
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("none")) {
                        dmlOptions.linReuseType = LineageCacheConfig.ReuseCacheType.NONE;
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("policy_lru")) {
                        dmlOptions.linCachePolicy = LineageCacheConfig.LineageCachePolicy.LRU;
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("policy_costnsize")) {
                        dmlOptions.linCachePolicy = LineageCacheConfig.LineageCachePolicy.COSTNSIZE;
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("policy_dagheight")) {
                        dmlOptions.linCachePolicy = LineageCacheConfig.LineageCachePolicy.DAGHEIGHT;
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("estimate")) {
                        dmlOptions.lineage_estimate = lineageType.equalsIgnoreCase("estimate");
                        continue;
                    }
                    if (lineageType.equalsIgnoreCase("debugger")) {
                        dmlOptions.lineage_debugger = lineageType.equalsIgnoreCase("debugger");
                        continue;
                    }
                    throw new ParseException("Invalid argument specified for -lineage option: " + lineageType);
                }
            }
        }
        dmlOptions.debug = line.hasOption("debug");
        dmlOptions.gpu = line.hasOption("gpu");
        if (dmlOptions.gpu && (force = line.getOptionValue("gpu")) != null) {
            if (force.equalsIgnoreCase("force")) {
                dmlOptions.forceGPU = true;
            } else {
                throw new ParseException("Invalid argument specified for -gpu option");
            }
        }
        if (line.hasOption("exec") && (execMode = line.getOptionValue("exec")) != null) {
            if (execMode.equalsIgnoreCase("singlenode")) {
                dmlOptions.execMode = Types.ExecMode.SINGLE_NODE;
            } else if (execMode.equalsIgnoreCase("hybrid")) {
                dmlOptions.execMode = Types.ExecMode.HYBRID;
            } else if (execMode.equalsIgnoreCase("spark")) {
                dmlOptions.execMode = Types.ExecMode.SPARK;
            } else {
                throw new ParseException("Invalid argument specified for -exec option, must be one of [hadoop, singlenode, hybrid, HYBRID, spark]");
            }
        }
        if (line.hasOption("explain")) {
            dmlOptions.explainType = Explain.ExplainType.RUNTIME;
            String explainType = line.getOptionValue("explain");
            if (explainType != null) {
                if (explainType.equalsIgnoreCase("hops")) {
                    dmlOptions.explainType = Explain.ExplainType.HOPS;
                } else if (explainType.equalsIgnoreCase("runtime")) {
                    dmlOptions.explainType = Explain.ExplainType.RUNTIME;
                } else if (explainType.equalsIgnoreCase("recompile_hops")) {
                    dmlOptions.explainType = Explain.ExplainType.RECOMPILE_HOPS;
                } else if (explainType.equalsIgnoreCase("recompile_runtime")) {
                    dmlOptions.explainType = Explain.ExplainType.RECOMPILE_RUNTIME;
                } else {
                    throw new ParseException("Invalid argument specified for -hops option, must be one of [hops, runtime, recompile_hops, recompile_runtime]");
                }
            }
        }
        dmlOptions.stats = line.hasOption("stats");
        if (dmlOptions.stats && (statsCount = line.getOptionValue("stats")) != null) {
            try {
                dmlOptions.statsCount = Integer.parseInt(statsCount);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid argument specified for -stats option, must be a valid integer");
            }
        }
        dmlOptions.fedStats = line.hasOption("fedStats");
        if (dmlOptions.fedStats && (fedStatsCount = line.getOptionValue("fedStats")) != null) {
            try {
                dmlOptions.fedStatsCount = Integer.parseInt(fedStatsCount);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid argument specified for -fedStats option, must be a valid integer");
            }
        }
        dmlOptions.memStats = line.hasOption("mem");
        dmlOptions.clean = line.hasOption("clean");
        if (line.hasOption("config")) {
            dmlOptions.configFile = line.getOptionValue("config");
        }
        if (line.hasOption("w")) {
            dmlOptions.fedWorker = true;
            dmlOptions.fedWorkerPort = Integer.parseInt(line.getOptionValue("w"));
        }
        if (line.hasOption("fedMonitor")) {
            dmlOptions.fedMonitoring = true;
            dmlOptions.fedMonitoringPort = Integer.parseInt(line.getOptionValue("fedMonitor"));
        }
        if (line.hasOption("f")) {
            dmlOptions.filePath = line.getOptionValue("f");
        }
        if (line.hasOption("s")) {
            dmlOptions.script = line.getOptionValue("s");
        }
        if (line.hasOption("args")) {
            String[] argValues = line.getOptionValues("args");
            for (int k = 0; k < argValues.length; ++k) {
                String str = argValues[k];
                if (str.isEmpty()) continue;
                dmlOptions.argVals.put("$" + (k + 1), str);
            }
        }
        if (line.hasOption("python")) {
            dmlOptions.pythonPort = Integer.parseInt(line.getOptionValue("python"));
        }
        if (line.hasOption("nvargs")) {
            String[] nvargValues;
            String varNameRegex = "^[a-zA-Z]([a-zA-Z0-9_])*$";
            String[] stringArray = nvargValues = line.getOptionValues("nvargs");
            int n = stringArray.length;
            for (int lineageType = 0; lineageType < n; ++lineageType) {
                String str = stringArray[lineageType];
                if (str.isEmpty()) continue;
                String[] kv = str.split("=");
                if (kv.length != 2) {
                    throw new ParseException("Invalid argument specified for -nvargs option, must be a list of space separated K=V pairs, where K is a valid name of a variable in the DML/PyDML program");
                }
                if (!kv[0].matches(varNameRegex)) {
                    throw new ParseException("Invalid argument specified for -nvargs option, " + kv[0] + " does not seem like a valid variable name in DML. Valid variable names in DML start with upper-case or lower-case letter, and contain only letters, digits, or underscores");
                }
                dmlOptions.argVals.put("$" + kv[0], kv[1]);
            }
        }
        dmlOptions.checkPrivacy = line.hasOption("checkPrivacy");
        if (line.hasOption("federatedCompilation")) {
            OptimizerUtils.FEDERATED_COMPILATION = true;
            dmlOptions.federatedCompilation = true;
            String[] fedCompSpecs = line.getOptionValues("federatedCompilation");
            if (fedCompSpecs != null && fedCompSpecs.length > 0) {
                for (String spec : fedCompSpecs) {
                    String[] specPair = spec.split("=");
                    if (specPair.length != 2) {
                        throw new ParseException("Invalid argument specified for -federatedCompilation option, must be a list of space separated K=V pairs, where K is a line number of the DML script and V is a federated output value");
                    }
                    int dmlLineNum = Integer.parseInt(specPair[0]);
                    FEDInstruction.FederatedOutput fedOutSpec = FEDInstruction.FederatedOutput.valueOf(specPair[1]);
                    OptimizerUtils.FEDERATED_SPECS.put(dmlLineNum, fedOutSpec);
                }
            }
        }
        if (line.hasOption("noFedRuntimeConversion")) {
            FEDInstructionUtils.noFedRuntimeConversion = true;
            dmlOptions.noFedRuntimeConversion = true;
        }
        if (line.hasOption("seed")) {
            dmlOptions.seed = Integer.parseInt(line.getOptionValue("seed"));
        }
        return dmlOptions;
    }

    private static Options createCLIOptions() {
        Options options = new Options();
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withDescription((String)"parameterizes DML script with named parameters of the form <key=value>; <key> should be a valid identifier in DML/PyDML");
        OptionBuilder.hasArgs();
        Option nvargsOpt = OptionBuilder.create((String)"nvargs");
        OptionBuilder.withArgName((String)"argN");
        OptionBuilder.withDescription((String)"specifies positional parameters; first value will replace $1 in DML program; $2 will replace 2nd and so on");
        OptionBuilder.hasArgs();
        Option argsOpt = OptionBuilder.create((String)"args");
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.withDescription((String)"uses a given configuration file (can be on local/hdfs/gpfs; default values in SystemDS-config.xml");
        OptionBuilder.hasArg();
        Option configOpt = OptionBuilder.create((String)"config");
        OptionBuilder.withDescription((String)"cleans up all SystemDS working directories (FS, DFS); all other flags are ignored in this mode.");
        Option cleanOpt = OptionBuilder.create((String)"clean");
        OptionBuilder.withArgName((String)"count");
        OptionBuilder.withDescription((String)"monitors and reports summary execution statistics; heavy hitter <count> is 10 unless overridden; default off");
        OptionBuilder.hasOptionalArg();
        Option statsOpt = OptionBuilder.create((String)"stats");
        OptionBuilder.withArgName((String)"count");
        OptionBuilder.withDescription((String)"monitors and reports summary execution statistics of federated workers; heavy hitter <count> is 10 unless overridden; default off");
        OptionBuilder.hasOptionalArg();
        Option fedStatsOpt = OptionBuilder.create((String)"fedStats");
        OptionBuilder.withDescription((String)"monitors and reports max memory consumption in CP; default off");
        Option memOpt = OptionBuilder.create((String)"mem");
        OptionBuilder.withArgName((String)"level");
        OptionBuilder.withDescription((String)"explains plan levels; can be 'hops' / 'runtime'[default] / 'recompile_hops' / 'recompile_runtime'");
        OptionBuilder.hasOptionalArg();
        Option explainOpt = OptionBuilder.create((String)"explain");
        OptionBuilder.withArgName((String)"mode");
        OptionBuilder.withDescription((String)"sets execution mode; can be 'hadoop' / 'singlenode' / 'hybrid'[default] / 'HYBRID' / 'spark'");
        OptionBuilder.hasArg();
        Option execOpt = OptionBuilder.create((String)"exec");
        OptionBuilder.withArgName((String)"force");
        OptionBuilder.withDescription((String)"uses CUDA instructions when reasonable; set <force> option to skip conservative memory estimates and use GPU wherever possible; default off");
        OptionBuilder.hasOptionalArg();
        Option gpuOpt = OptionBuilder.create((String)"gpu");
        OptionBuilder.withDescription((String)"runs in debug mode; default off");
        Option debugOpt = OptionBuilder.create((String)"debug");
        OptionBuilder.withDescription((String)"Python Context start with port argument for communication to python");
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        Option pythonOpt = OptionBuilder.create((String)"python");
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.withDescription((String)"specifies dml/pydml file to execute; path can be local/hdfs/gpfs (prefixed with appropriate URI)");
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        Option fileOpt = OptionBuilder.create((String)"f");
        OptionBuilder.withArgName((String)"script_contents");
        OptionBuilder.withDescription((String)"specified script string to execute directly");
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        Option scriptOpt = OptionBuilder.create((String)"s");
        OptionBuilder.withDescription((String)"shows usage message");
        Option helpOpt = OptionBuilder.create((String)"help");
        OptionBuilder.withDescription((String)"computes lineage traces");
        OptionBuilder.hasOptionalArgs();
        Option lineageOpt = OptionBuilder.create((String)"lineage");
        OptionBuilder.withDescription((String)"starts a federated worker with the given argument as the port.");
        OptionBuilder.hasOptionalArg();
        Option fedOpt = OptionBuilder.create((String)"w");
        OptionBuilder.withDescription((String)"Starts a federated monitoring backend with the given argument as the port.");
        OptionBuilder.hasOptionalArg();
        Option monitorOpt = OptionBuilder.create((String)"fedMonitor");
        OptionBuilder.withDescription((String)"Check which privacy constraints are loaded and checked during federated execution");
        Option checkPrivacy = OptionBuilder.create((String)"checkPrivacy");
        OptionBuilder.withArgName((String)"key=value");
        OptionBuilder.withDescription((String)"Compile federated instructions based on input federation state and privacy constraints.");
        OptionBuilder.hasOptionalArgs();
        Option federatedCompilation = OptionBuilder.create((String)"federatedCompilation");
        OptionBuilder.withDescription((String)"If activated, no runtime conversion of CP instructions to FED instructions will be performed.");
        Option noFedRuntimeConversion = OptionBuilder.create((String)"noFedRuntimeConversion");
        OptionBuilder.withDescription((String)"A general seed for the execution through the commandline");
        OptionBuilder.hasArg();
        Option commandlineSeed = OptionBuilder.create((String)"seed");
        options.addOption(configOpt);
        options.addOption(cleanOpt);
        options.addOption(statsOpt);
        options.addOption(fedStatsOpt);
        options.addOption(memOpt);
        options.addOption(explainOpt);
        options.addOption(execOpt);
        options.addOption(gpuOpt);
        options.addOption(debugOpt);
        options.addOption(lineageOpt);
        options.addOption(fedOpt);
        options.addOption(monitorOpt);
        options.addOption(checkPrivacy);
        options.addOption(federatedCompilation);
        options.addOption(noFedRuntimeConversion);
        options.addOption(commandlineSeed);
        OptionGroup fileOrScriptOpt = new OptionGroup().addOption(scriptOpt).addOption(fileOpt).addOption(cleanOpt).addOption(helpOpt).addOption(fedOpt).addOption(monitorOpt).addOption(pythonOpt);
        fileOrScriptOpt.setRequired(true);
        options.addOptionGroup(fileOrScriptOpt);
        options.addOptionGroup(new OptionGroup().addOption(nvargsOpt).addOption(argsOpt));
        options.addOption(helpOpt);
        return options;
    }
}

