/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.cocode.CoCoderFactory;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.InsertionSorterFactory;
import org.apache.sysds.runtime.compress.cost.CostEstimatorFactory;
import org.apache.sysds.runtime.compress.estim.sample.SampleEstimatorFactory;

public class CompressionSettings {
    private static final Log LOG = LogFactory.getLog((String)CompressionSettings.class.getName());
    public static int PAR_DDC_THRESHOLD = 10000;
    public static final int BITMAP_BLOCK_SZ = 65535;
    public final boolean sortTuplesByFrequency;
    public final double samplingRatio;
    public final double samplePower;
    public final boolean allowSharedDictionary;
    public final String transposeInput;
    public final int seed;
    public final boolean lossy;
    public final CoCoderFactory.PartitionerType columnPartitioner;
    public final CostEstimatorFactory.CostType costComputationType;
    public final int maxColGroupCoCode;
    public final double coCodePercentage;
    public final EnumSet<AColGroup.CompressionType> validCompressions;
    public final int minimumSampleSize;
    public final int maxSampleSize;
    public final SampleEstimatorFactory.EstimationType estimationType;
    public boolean transposed = false;
    public final double minimumCompressionRatio;
    public final boolean isInSparkInstruction;
    public final InsertionSorterFactory.SORT_TYPE sdcSortType;

    protected CompressionSettings(double samplingRatio, double samplePower, boolean allowSharedDictionary, String transposeInput, int seed, boolean lossy, EnumSet<AColGroup.CompressionType> validCompressions, boolean sortValuesByLength, CoCoderFactory.PartitionerType columnPartitioner, int maxColGroupCoCode, double coCodePercentage, int minimumSampleSize, int maxSampleSize, SampleEstimatorFactory.EstimationType estimationType, CostEstimatorFactory.CostType costComputationType, double minimumCompressionRatio, boolean isInSparkInstruction, InsertionSorterFactory.SORT_TYPE sdcSortType) {
        this.samplingRatio = samplingRatio;
        this.samplePower = samplePower;
        this.allowSharedDictionary = allowSharedDictionary;
        this.transposeInput = transposeInput;
        this.seed = seed == -1 ? (int)System.nanoTime() : seed;
        this.validCompressions = validCompressions;
        this.lossy = lossy;
        this.sortTuplesByFrequency = sortValuesByLength;
        this.columnPartitioner = columnPartitioner;
        this.maxColGroupCoCode = maxColGroupCoCode;
        this.coCodePercentage = coCodePercentage;
        this.minimumSampleSize = minimumSampleSize;
        this.maxSampleSize = maxSampleSize;
        this.estimationType = estimationType;
        this.costComputationType = costComputationType;
        this.minimumCompressionRatio = minimumCompressionRatio;
        this.isInSparkInstruction = isInSparkInstruction;
        this.sdcSortType = sdcSortType;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompressionSettings: ");
        sb.append("\t Valid Compressions: " + this.validCompressions);
        sb.append("\t Share dict: " + this.allowSharedDictionary);
        sb.append("\t Partitioner: " + this.columnPartitioner);
        sb.append("\t Lossy: " + this.lossy);
        sb.append("\t Cost Computation Type: " + this.costComputationType);
        if (this.samplingRatio < 1.0) {
            sb.append("\t Estimation Type: " + this.estimationType);
        }
        return sb.toString();
    }
}

