/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictLibMatrixMult;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.data.SparseBlockFactory;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.LeftScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class MatrixBlockDictionary
extends ADictionary {
    private static final long serialVersionUID = 2535887782150955098L;
    private final MatrixBlock _data;

    private MatrixBlockDictionary(MatrixBlock data) {
        this._data = data;
    }

    public MatrixBlockDictionary(MatrixBlock data, int nCol) {
        data.examSparsity(true);
        if (data.getNumColumns() != nCol) {
            throw new DMLCompressionException("Invalid number of columns in dictionary");
        }
        if (data.isEmpty()) {
            throw new DMLCompressionException("Invalid construction of empty dictionary");
        }
        if (data.isInSparseFormat() && data.getSparseBlock() instanceof SparseBlockMCSR) {
            SparseBlock csr = SparseBlockFactory.copySparseBlock(SparseBlock.Type.CSR, data.getSparseBlock(), false);
            data.setSparseBlock(csr);
        }
        this._data = data;
    }

    public static MatrixBlockDictionary createDictionary(double[] values, int nCol) {
        MatrixBlock nd = Util.matrixBlockFromDenseArray(values, nCol);
        nd.examSparsity(true);
        if (nd.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(nd);
    }

    public MatrixBlock getMatrixBlock() {
        return this._data;
    }

    @Override
    public double[] getValues() {
        if (this._data.isInSparseFormat()) {
            LOG.warn((Object)"Inefficient call to getValues for a MatrixBlockDictionary because it was sparse");
            throw new DMLCompressionException("Should not call this function");
        }
        return this._data.getDenseBlockValues();
    }

    @Override
    public double getValue(int i) {
        int nCol = this._data.getNumColumns();
        int row = i / nCol;
        if (row > this._data.getNumRows()) {
            return 0.0;
        }
        int col = i % nCol;
        return this._data.quickGetValue(row, col);
    }

    @Override
    public long getInMemorySize() {
        return 8L + this._data.estimateSizeInMemory();
    }

    public static long getInMemorySize(int numberValues, int numberColumns, double sparsity) {
        return 8L + MatrixBlock.estimateSizeInMemory(numberValues, numberColumns, sparsity);
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MAX) {
            return fn.execute(init, this._data.max());
        }
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MIN) {
            return fn.execute(init, this._data.min());
        }
        throw new NotImplementedException();
    }

    @Override
    public double aggregateWithReference(double init, Builtin fn, double[] reference, boolean def) {
        double ret;
        block9: {
            int nRows;
            block8: {
                int nCol = reference.length;
                nRows = this._data.getNumRows();
                ret = init;
                if (def) {
                    for (int i = 0; i < nCol; ++i) {
                        ret = fn.execute(ret, reference[i]);
                    }
                }
                if (this._data.isEmpty() || !this._data.isInSparseFormat()) break block8;
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < nRows; ++i) {
                    if (sb.isEmpty(i)) continue;
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    int[] aix = sb.indexes(i);
                    double[] avals = sb.values(i);
                    for (int k = apos; k < alen; ++k) {
                        double v = avals[k] + reference[aix[k]];
                        ret = fn.execute(ret, v);
                    }
                }
                if (def) break block9;
                int[] nnz = LibMatrixReorg.countNnzPerColumn(this._data);
                for (int i = 0; i < nnz.length; ++i) {
                    if (nnz[i] >= nRows) continue;
                    ret = fn.execute(ret, reference[i]);
                }
                break block9;
            }
            if (!this._data.isEmpty()) {
                double[] values = this._data.getDenseBlockValues();
                int off = 0;
                for (int k = 0; k < nRows; ++k) {
                    for (int j = 0; j < this._data.getNumColumns(); ++j) {
                        double v = values[off++] + reference[j];
                        ret = fn.execute(ret, v);
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public double[] aggregateRows(Builtin fn, int nCol) {
        double[] ret = new double[this._data.getNumRows()];
        if (this._data.isEmpty()) {
            return ret;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (!sb.isEmpty(i)) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    ret[i] = avals[apos];
                    for (int j = apos + 1; j < alen; ++j) {
                        ret[i] = fn.execute(ret[i], avals[j]);
                    }
                    if (sb.size(i) >= this._data.getNumColumns()) continue;
                    ret[i] = fn.execute(ret[i], 0.0);
                    continue;
                }
                ret[i] = fn.execute(ret[i], 0.0);
            }
        } else {
            if (nCol == 1) {
                return this._data.getDenseBlockValues();
            }
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                ret[k] = values[off++];
                for (int j = 1; j < this._data.getNumColumns(); ++j) {
                    ret[k] = fn.execute(ret[k], values[off++]);
                }
            }
        }
        return ret;
    }

    @Override
    public double[] aggregateRowsWithDefault(Builtin fn, double[] defaultTuple) {
        throw new NotImplementedException();
    }

    @Override
    public double[] aggregateRowsWithReference(Builtin fn, double[] reference) {
        double[] ret;
        block8: {
            int nRows;
            block7: {
                int nCol = reference.length;
                nRows = this._data.getNumRows();
                ret = new double[nRows + 1];
                ret[nRows] = reference[0];
                for (int i = 1; i < nCol; ++i) {
                    ret[nRows] = fn.execute(ret[nRows], reference[i]);
                }
                if (this._data.isEmpty() || !this._data.isInSparseFormat()) break block7;
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < nRows; ++i) {
                    int j;
                    if (sb.isEmpty(i)) {
                        ret[i] = ret[nRows];
                        continue;
                    }
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    int[] aix = sb.indexes(i);
                    double[] avals = sb.values(i);
                    int k = apos;
                    double d = ret[i] = aix[k] == 0 ? avals[k++] + reference[0] : reference[0];
                    for (j = 1; j < this._data.getNumColumns() && k < alen; ++j) {
                        double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                        ret[i] = fn.execute(ret[i], v);
                    }
                    while (j < this._data.getNumColumns()) {
                        ret[i] = fn.execute(ret[i], reference[j]);
                        ++j;
                    }
                }
                break block8;
            }
            if (this._data.isEmpty()) break block8;
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRows; ++k) {
                ret[k] = values[off++] + reference[0];
                for (int j = 1; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    ret[k] = fn.execute(ret[k], v);
                }
            }
        }
        return ret;
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, int[] colIndexes) {
        if (this._data.isEmpty()) {
            for (int j = 0; j < colIndexes.length; ++j) {
                int idx = colIndexes[j];
                c[idx] = fn.execute(c[idx], 0.0);
            }
        } else if (this._data.isInSparseFormat()) {
            MatrixBlock t = LibMatrixReorg.transposeInPlace(this._data, 1);
            if (!t.isInSparseFormat()) {
                throw new NotImplementedException();
            }
            SparseBlock sbt = t.getSparseBlock();
            for (int i = 0; i < this._data.getNumColumns(); ++i) {
                int idx = colIndexes[i];
                if (!sbt.isEmpty(i)) {
                    int apos = sbt.pos(i);
                    int alen = sbt.size(i) + apos;
                    double[] avals = sbt.values(i);
                    for (int j = apos; j < alen; ++j) {
                        c[idx] = fn.execute(c[idx], avals[j]);
                    }
                    if (alen == this._data.getNumRows()) continue;
                    c[idx] = fn.execute(c[idx], 0.0);
                    continue;
                }
                c[idx] = fn.execute(c[idx], 0.0);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    int idx = colIndexes[j];
                    c[idx] = fn.execute(c[idx], values[off++]);
                }
            }
        }
    }

    @Override
    public void aggregateColsWithReference(double[] c, Builtin fn, int[] colIndexes, double[] reference, boolean def) {
        block8: {
            int nRow;
            int nCol;
            block7: {
                nCol = this._data.getNumColumns();
                nRow = this._data.getNumRows();
                if (def) {
                    for (int j = 0; j < colIndexes.length; ++j) {
                        int idx = colIndexes[j];
                        c[idx] = fn.execute(c[idx], reference[j]);
                    }
                }
                if (!this._data.isInSparseFormat()) break block7;
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < nRow; ++i) {
                    if (sb.isEmpty(i)) continue;
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    int[] aix = sb.indexes(i);
                    for (int k = apos; k < alen; ++k) {
                        int idx = colIndexes[aix[k]];
                        c[idx] = fn.execute(c[idx], avals[k] + reference[aix[k]]);
                    }
                }
                if (def) break block8;
                int[] nnz = LibMatrixReorg.countNnzPerColumn(this._data);
                for (int i = 0; i < nnz.length; ++i) {
                    if (nnz[i] >= nRow) continue;
                    int idx = colIndexes[i];
                    c[idx] = fn.execute(c[idx], reference[i]);
                }
                break block8;
            }
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int j = 0; j < nCol; ++j) {
                    int idx = colIndexes[j];
                    c[idx] = fn.execute(c[idx], values[off++] + reference[j]);
                }
            }
        }
    }

    @Override
    public ADictionary applyScalarOp(ScalarOperator op) {
        MatrixBlock res = this._data.scalarOperations(op, new MatrixBlock());
        if (res.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(res, this._data.getNumColumns());
    }

    @Override
    public ADictionary applyUnaryOp(UnaryOperator op) {
        MatrixBlock res = this._data.unaryOperations(op, new MatrixBlock());
        if (res.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(res, this._data.getNumColumns());
    }

    @Override
    public ADictionary applyScalarOpWithReference(ScalarOperator op, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.executeScalar(reference[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.executeScalar(v) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.executeScalar(reference[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.executeScalar(values[off] + reference[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        if (ret.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(ret, nCol);
    }

    @Override
    public ADictionary applyUnaryOpWithReference(UnaryOperator op, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.fn.execute(reference[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.fn.execute(v) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.fn.execute(reference[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(values[off] + reference[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        if (ret.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(ret, nCol);
    }

    @Override
    public ADictionary inplaceScalarOp(ScalarOperator op) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary binOpLeft(BinaryOperator op, double[] v, int[] colIndexes) {
        throw new NotImplementedException("Binary row op left is not supported for Uncompressed Matrix, Implement support for VMr in MatrixBlock Binary Cell operations");
    }

    @Override
    public Dictionary binOpLeftWithReference(BinaryOperator op, double[] v, int[] colIndexes, double[] reference, double[] newReference) {
        throw new NotImplementedException();
    }

    @Override
    public MatrixBlockDictionary binOpRight(BinaryOperator op, double[] v, int[] colIndexes) {
        MatrixBlock rowVector = Util.extractValues(v, colIndexes);
        return new MatrixBlockDictionary(this._data.binaryOperations(op, rowVector, null), this._data.getNumColumns());
    }

    @Override
    public MatrixBlockDictionary binOpRight(BinaryOperator op, double[] v) {
        MatrixBlock rowVector = new MatrixBlock(1, v.length, v);
        MatrixBlock ret = this._data.binaryOperations(op, rowVector, null);
        ret.examSparsity(true);
        return new MatrixBlockDictionary(ret, this._data.getNumColumns());
    }

    @Override
    public Dictionary binOpRightWithReference(BinaryOperator op, double[] v, int[] colIndexes, double[] reference, double[] newReference) {
        throw new NotImplementedException();
    }

    @Override
    public ADictionary clone() {
        MatrixBlock ret = new MatrixBlock();
        ret.copy(this._data);
        return new MatrixBlockDictionary(ret, this._data.getNumColumns());
    }

    @Override
    public boolean isLossy() {
        return false;
    }

    @Override
    public int getNumberOfValues(int ncol) {
        return this._data.getNumRows();
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        double[] ret = new double[this._data.getNumRows()];
        if (this._data.isEmpty()) {
            return ret;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = i;
                    ret[n] = ret[n] + avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] + v;
                }
            }
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithDefault(double[] defaultTuple) {
        throw new NotImplementedException();
    }

    @Override
    public double[] sumAllRowsToDoubleWithReference(double[] reference) {
        double[] ret;
        block8: {
            int numVals;
            block7: {
                int nCol = reference.length;
                numVals = this._data.getNumRows();
                ret = new double[numVals + 1];
                int finalIndex = numVals;
                for (int i = 0; i < nCol; ++i) {
                    int n = finalIndex;
                    ret[n] = ret[n] + reference[i];
                }
                if (this._data.isEmpty() || !this._data.isInSparseFormat()) break block7;
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < numVals; ++i) {
                    int j;
                    if (sb.isEmpty(i)) {
                        ret[i] = ret[finalIndex];
                        continue;
                    }
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    int[] aix = sb.indexes(i);
                    double[] avals = sb.values(i);
                    int k = apos;
                    for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                        double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                        int n = i;
                        ret[n] = ret[n] + v;
                    }
                    while (j < this._data.getNumColumns()) {
                        int n = i;
                        ret[n] = ret[n] + reference[j];
                        ++j;
                    }
                }
                break block8;
            }
            if (this._data.isEmpty()) break block8;
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = k;
                    ret[n] = ret[n] + v;
                }
            }
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        double[] ret = new double[this._data.getNumRows()];
        this.sumAllRowsToDoubleSq(ret);
        return ret;
    }

    private void sumAllRowsToDoubleSq(double[] ret) {
        if (this._data.isEmpty()) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = i;
                    ret[n] = ret[n] + avals[j] * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] + v * v;
                }
            }
        }
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithDefault(double[] defaultTuple) {
        double[] ret = new double[this._data.getNumRows() + 1];
        this.sumAllRowsToDoubleSq(ret);
        int defIdx = ret.length - 1;
        for (int j = 0; j < this._data.getNumColumns(); ++j) {
            double v = defaultTuple[j];
            int n = defIdx;
            ret[n] = ret[n] + v * v;
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithReference(double[] reference) {
        double[] ret;
        block8: {
            int numVals;
            block7: {
                int nCol = reference.length;
                numVals = this._data.getNumRows();
                ret = new double[numVals + 1];
                int finalIndex = numVals;
                for (int i = 0; i < nCol; ++i) {
                    int n = finalIndex;
                    ret[n] = ret[n] + reference[i] * reference[i];
                }
                if (this._data.isEmpty() || !this._data.isInSparseFormat()) break block7;
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < numVals; ++i) {
                    int j;
                    if (sb.isEmpty(i)) {
                        ret[i] = ret[finalIndex];
                        continue;
                    }
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    int[] aix = sb.indexes(i);
                    double[] avals = sb.values(i);
                    int k = apos;
                    for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                        double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                        int n = i;
                        ret[n] = ret[n] + v * v;
                    }
                    while (j < this._data.getNumColumns()) {
                        int n = i;
                        ret[n] = ret[n] + reference[j] * reference[j];
                        ++j;
                    }
                }
                break block8;
            }
            if (this._data.isEmpty()) break block8;
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = k;
                    ret[n] = ret[n] + v * v;
                }
            }
        }
        return ret;
    }

    @Override
    public void colSum(double[] c, int[] counts, int[] colIndexes) {
        if (this._data.isEmpty()) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes[aix[j]];
                    c[n] = c[n] + (double)count * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = colIndexes[j];
                    c[n] = c[n] + v * (double)countK;
                }
            }
        }
    }

    @Override
    public void colSumSq(double[] c, int[] counts, int[] colIndexes) {
        if (this._data.isEmpty()) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes[aix[j]];
                    c[n] = c[n] + (double)count * avals[j] * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = colIndexes[j];
                    c[n] = c[n] + v * v * (double)countK;
                }
            }
        }
    }

    @Override
    public void colSumSqWithReference(double[] c, int[] counts, int[] colIndexes, double[] reference) {
        int nCol = reference.length;
        int nRow = counts.length;
        if (this._data.isEmpty()) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                int countK = counts[i];
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        int n = colIndexes[j2];
                        c[n] = c[n] + reference[j2] * reference[j2] * (double)countK;
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    int n = colIndexes[j];
                    c[n] = c[n] + v * v * (double)countK;
                }
                while (j < this._data.getNumColumns()) {
                    int n = colIndexes[j];
                    c[n] = c[n] + reference[j] * reference[j] * (double)countK;
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRow; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = colIndexes[j];
                    c[n] = c[n] + v * v * (double)countK;
                }
            }
        }
    }

    @Override
    public double sum(int[] counts, int ncol) {
        double tmpSum = 0.0;
        if (this._data.isEmpty()) {
            return tmpSum;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    tmpSum += (double)count * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    tmpSum += v * (double)countK;
                }
            }
        }
        return tmpSum;
    }

    @Override
    public double sumSq(int[] counts, int ncol) {
        double tmpSum = 0.0;
        if (this._data.isEmpty()) {
            return tmpSum;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    tmpSum += (double)count * avals[j] * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    tmpSum += v * v * (double)countK;
                }
            }
        }
        return tmpSum;
    }

    @Override
    public double sumSqWithReference(int[] counts, double[] reference) {
        if (this._data.isEmpty()) {
            return 0.0;
        }
        int nCol = reference.length;
        int numVals = counts.length;
        double ret = 0.0;
        if (this._data.isInSparseFormat()) {
            double ref = 0.0;
            for (int i = 0; i < nCol; ++i) {
                ref += reference[i] * reference[i];
            }
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < numVals; ++i) {
                int j;
                int countK = counts[i];
                if (sb.isEmpty(i)) {
                    ret += ref * (double)countK;
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    ret += v * v * (double)countK;
                }
                while (j < this._data.getNumColumns()) {
                    ret += reference[j] * reference[j] * (double)countK;
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    ret += v * v * (double)countK;
                }
            }
        }
        return ret;
    }

    @Override
    public ADictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        MatrixBlock retBlock = this._data.slice(0, this._data.getNumRows() - 1, idxStart, idxEnd - 1);
        if (retBlock.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(retBlock, idxEnd - idxStart);
    }

    @Override
    public boolean containsValue(double pattern) {
        return this._data.containsValue(pattern);
    }

    @Override
    public boolean containsValueWithReference(double pattern, double[] reference) {
        if (this._data.isEmpty()) {
            for (double d : reference) {
                if (pattern != d) continue;
                return true;
            }
            return false;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                int j;
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    if (!(aix[k] == j ? reference[j] + avals[k++] == pattern : reference[j] == pattern)) continue;
                    return true;
                }
                while (j < this._data.getNumColumns()) {
                    if (reference[j] == pattern) {
                        return true;
                    }
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int nCol = reference.length;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] + reference[i % nCol] != pattern) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        if (this._data.isEmpty()) {
            return 0L;
        }
        long nnz = 0L;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                nnz += (long)(sb.size(i) * counts[i]);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int i = 0; i < counts.length; ++i) {
                int countThisTuple = 0;
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v;
                    if ((v = values[off++]) == 0.0) continue;
                    ++countThisTuple;
                }
                nnz += (long)(countThisTuple * counts[i]);
            }
        }
        return nnz;
    }

    @Override
    public long getNumberNonZerosWithReference(int[] counts, double[] reference, int nRows) {
        long nnz = 0L;
        if (this._data.isEmpty()) {
            return nnz;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            long emptyRowNNZ = nnz;
            for (int i = 0; i < counts.length; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    nnz += emptyRowNNZ * (long)counts[i];
                    continue;
                }
                int countThis = 0;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    if (aix[k] == j) {
                        if (reference[j] + avals[k++] == 0.0) continue;
                        ++countThis;
                        continue;
                    }
                    if (reference[j] == 0.0) continue;
                    ++countThis;
                }
                while (j < this._data.getNumColumns()) {
                    if (reference[j] != 0.0) {
                        ++countThis;
                    }
                    ++j;
                }
                nnz += (long)(countThis * counts[i]);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int i = 0; i < counts.length; ++i) {
                int countThisTuple = 0;
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    if (values[off++] + reference[j] == 0.0) continue;
                    ++countThisTuple;
                }
                nnz += (long)(countThisTuple * counts[i]);
            }
        }
        return nnz;
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol) {
        if (this._data.isInSparseFormat()) {
            MatrixBlockDictionary.addToEntrySparse(this._data.getSparseBlock(), v, fr, to * nCol, nCol);
        } else {
            MatrixBlockDictionary.addToEntryDense(this._data.getDenseBlockValues(), v, fr * nCol, to * nCol, nCol);
        }
    }

    private static final void addToEntrySparse(SparseBlock sb, double[] v, int fr, int st, int nCol) {
        if (sb.isEmpty(fr)) {
            return;
        }
        int apos = sb.pos(fr);
        int alen = sb.size(fr) + apos;
        int[] aix = sb.indexes(fr);
        double[] avals = sb.values(fr);
        for (int j = apos; j < alen; ++j) {
            int n = st + aix[j];
            v[n] = v[n] + avals[j];
        }
    }

    private static final void addToEntryDense(double[] thisV, double[] v, int sf, int st, int nCol) {
        int j = st;
        for (int i = sf; i < sf + nCol; ++i) {
            int n = j++;
            v[n] = v[n] + thisV[i];
        }
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol, int rep) {
        if (this._data.isInSparseFormat()) {
            MatrixBlockDictionary.addToEntrySparse(this._data.getSparseBlock(), v, fr, to * nCol, nCol, rep);
        } else {
            MatrixBlockDictionary.addToEntryDense(this._data.getDenseBlockValues(), v, fr * nCol, to * nCol, nCol, rep);
        }
    }

    private static final void addToEntrySparse(SparseBlock sb, double[] v, int fr, int st, int nCol, int rep) {
        if (sb.isEmpty(fr)) {
            return;
        }
        int apos = sb.pos(fr);
        int alen = sb.size(fr) + apos;
        int[] aix = sb.indexes(fr);
        double[] avals = sb.values(fr);
        for (int j = apos; j < alen; ++j) {
            int n = st + aix[j];
            v[n] = v[n] + avals[j] * (double)rep;
        }
    }

    private static final void addToEntrySparseCSR(SparseBlockCSR sb, double[] v, int fr, int st, int nCol, int[] aix, double[] avals) {
        int apos = sb.pos(fr);
        int alen = sb.size(fr) + apos;
        for (int j = apos; j < alen; ++j) {
            int n = st + aix[j];
            v[n] = v[n] + avals[j];
        }
    }

    private static final void addToEntryDense(double[] thisV, double[] v, int sf, int st, int nCol, int rep) {
        int j = st;
        for (int i = sf; i < sf + nCol; ++i) {
            int n = j++;
            v[n] = v[n] + thisV[i] * (double)rep;
        }
    }

    @Override
    public void addToEntryVectorized(double[] v, int f1, int f2, int f3, int f4, int f5, int f6, int f7, int f8, int t1, int t2, int t3, int t4, int t5, int t6, int t7, int t8, int nCol) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            if (sb instanceof SparseBlockCSR) {
                SparseBlockCSR csr = (SparseBlockCSR)sb;
                int[] aix = csr.indexes();
                double[] avals = csr.values();
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f1, t1 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f2, t2 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f3, t3 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f4, t4 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f5, t5 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f6, t6 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f7, t7 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f8, t8 * nCol, nCol, aix, avals);
            } else {
                MatrixBlockDictionary.addToEntrySparse(sb, v, f1, t1 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f2, t2 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f3, t3 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f4, t4 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f5, t5 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f6, t6 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f7, t7 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f8, t8 * nCol, nCol);
            }
        } else {
            double[] thisV = this._data.getDenseBlockValues();
            MatrixBlockDictionary.addToEntryDense(thisV, v, f1 * nCol, t1 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f2 * nCol, t2 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f3 * nCol, t3 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f4 * nCol, t4 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f5 * nCol, t5 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f6 * nCol, t6 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f7 * nCol, t7 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f8 * nCol, t8 * nCol, nCol);
        }
    }

    @Override
    public ADictionary subtractTuple(double[] tuple) {
        MatrixBlock v = new MatrixBlock(1, tuple.length, tuple);
        BinaryOperator op = new BinaryOperator(Minus.getMinusFnObject());
        MatrixBlock ret = this._data.binaryOperations(op, v, null);
        if (ret.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(ret, this._data.getNumColumns());
    }

    @Override
    public MatrixBlockDictionary getMBDict(int nCol) {
        return this;
    }

    @Override
    public String getString(int colIndexes) {
        if (this._data.isInSparseFormat() || this._data.getNumColumns() > 1) {
            return "\n" + this._data.toString();
        }
        return Arrays.toString(this._data.getDenseBlockValues());
    }

    public String toString() {
        if (this._data.isInSparseFormat() || this._data.getNumColumns() > 1) {
            return "MatrixBlock Dictionary :\n" + this._data.toString();
        }
        return "MatrixBlock Dictionary : " + Arrays.toString(this._data.getDenseBlockValues());
    }

    @Override
    public ADictionary scaleTuples(int[] scaling, int nCol) {
        if (this._data.isEmpty()) {
            throw new NotImplementedException("could return null here? or empty DictionaryMatrixBlock...");
        }
        if (this._data.isInSparseFormat()) {
            MatrixBlock retBlock = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), true);
            retBlock.allocateSparseRowsBlock(true);
            SparseBlock sbRet = retBlock.getSparseBlock();
            SparseBlock sbThis = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sbThis.isEmpty(i)) continue;
                sbRet.set(i, sbThis.get(i), true);
                int count = scaling[i];
                int apos = sbRet.pos(i);
                int alen = sbRet.size(i) + apos;
                double[] avals = sbRet.values(i);
                for (int j = apos; j < alen; ++j) {
                    avals[j] = (double)count * avals[j];
                }
            }
            retBlock.setNonZeros(this._data.getNonZeros());
            return new MatrixBlockDictionary(retBlock, this._data.getNumColumns());
        }
        double[] _values = this._data.getDenseBlockValues();
        double[] scaledValues = new double[_values.length];
        int off = 0;
        for (int tuple = 0; tuple < _values.length / nCol; ++tuple) {
            int scale = scaling[tuple];
            for (int v = 0; v < nCol; ++v) {
                scaledValues[off] = _values[off] * (double)scale;
                ++off;
            }
        }
        DenseBlockFP64 db = new DenseBlockFP64(new int[]{this._data.getNumRows(), this._data.getNumColumns()}, scaledValues);
        MatrixBlock retBlock = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), db);
        retBlock.setNonZeros(this._data.getNonZeros());
        return new MatrixBlockDictionary(retBlock, this._data.getNumColumns());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.MATRIX_BLOCK_DICT.ordinal());
        this._data.write(out);
    }

    public static MatrixBlockDictionary read(DataInput in) throws IOException {
        MatrixBlock ret = new MatrixBlock();
        ret.readFields(in);
        return new MatrixBlockDictionary(ret, ret.getNumColumns());
    }

    @Override
    public long getExactSizeOnDisk() {
        return 1L + this._data.getExactSizeOnDisk();
    }

    @Override
    public MatrixBlockDictionary preaggValuesFromDense(int numVals, int[] colIndexes, int[] aggregateColumns, double[] b, int cut) {
        double[] ret = new double[numVals * aggregateColumns.length];
        if (this._data.isEmpty()) {
            return null;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int off = aggregateColumns.length * i;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                int[] aix = sb.indexes(i);
                for (int j = apos; j < alen; ++j) {
                    int idb = colIndexes[aix[j]] * cut;
                    double v = avals[j];
                    for (int h = 0; h < aggregateColumns.length; ++h) {
                        int n = off + h;
                        ret[n] = ret[n] + v * b[idb + aggregateColumns[h]];
                    }
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int k = 0;
            int off = 0;
            while (k < numVals * colIndexes.length) {
                for (int h = 0; h < colIndexes.length; ++h) {
                    int idb = colIndexes[h] * cut;
                    double v = values[k + h];
                    if (v == 0.0) continue;
                    for (int i = 0; i < aggregateColumns.length; ++i) {
                        int n = off + i;
                        ret[n] = ret[n] + v * b[idb + aggregateColumns[i]];
                    }
                }
                k += colIndexes.length;
                off += aggregateColumns.length;
            }
        }
        DenseBlockFP64 dictV = new DenseBlockFP64(new int[]{numVals, aggregateColumns.length}, ret);
        MatrixBlock dictM = new MatrixBlock(numVals, aggregateColumns.length, dictV);
        dictM.recomputeNonZeros();
        dictM.examSparsity();
        return new MatrixBlockDictionary(dictM, aggregateColumns.length);
    }

    @Override
    public ADictionary replace(double pattern, double replace, int nCol) {
        MatrixBlock ret = this._data.replaceOperations(new MatrixBlock(), pattern, replace);
        if (ret.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(ret, this._data.getNumColumns());
    }

    @Override
    public ADictionary replaceWithReference(double pattern, double replace, double[] reference) {
        int nRow = this._data.getNumRows();
        int nCol = this._data.getNumColumns();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = pattern == reference[j2] ? replace - reference[j2] : 0.0;
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = pattern == v ? replace - reference[j] : v - reference[j];
                }
                while (j < nCol) {
                    retV[off++] = pattern == reference[j] ? replace - reference[j] : 0.0;
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    double v = values[off];
                    retV[off++] = pattern == v + reference[j] ? replace - reference[j] : v;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        if (ret.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(ret, this._data.getNumColumns());
    }

    @Override
    public void product(double[] ret, int[] counts, int nCol) {
        if (this._data.isEmpty()) {
            ret[0] = 0.0;
        } else if (this._data.isInSparseFormat()) {
            ret[0] = 0.0;
        } else if (this._data.getNonZeros() < (long)(this._data.getNumColumns() * this._data.getNumRows())) {
            ret[0] = 0.0;
        } else {
            MathContext cont = MathContext.DECIMAL128;
            int nRow = this._data.getNumRows();
            double[] values = this._data.getDenseBlockValues();
            BigDecimal tmp = BigDecimal.ONE;
            int off = 0;
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    double v = values[off++];
                    tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
                }
            }
            if (Math.abs(tmp.doubleValue()) == 0.0) {
                ret[0] = 0.0;
            } else if (!Double.isInfinite(ret[0])) {
                ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
            }
        }
    }

    @Override
    public void productWithDefault(double[] ret, int[] counts, double[] def, int defCount) {
        if (this._data.isEmpty()) {
            ret[0] = 0.0;
        } else if (this._data.isInSparseFormat()) {
            ret[0] = 0.0;
        } else if (this._data.getNonZeros() < (long)(this._data.getNumColumns() * this._data.getNumRows())) {
            ret[0] = 0.0;
        } else {
            MathContext cont = MathContext.DECIMAL128;
            int nRow = this._data.getNumRows();
            int nCol = def.length;
            double[] values = this._data.getDenseBlockValues();
            BigDecimal tmp = BigDecimal.ONE;
            int off = 0;
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    double v = values[off++];
                    tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
                }
            }
            for (int x = 0; x < def.length; ++x) {
                tmp = tmp.multiply(new BigDecimal(def[x]).pow(defCount, cont), cont);
            }
            if (Math.abs(tmp.doubleValue()) == 0.0) {
                ret[0] = 0.0;
            } else if (!Double.isInfinite(ret[0])) {
                ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
            }
        }
    }

    @Override
    public void productWithReference(double[] ret, int[] counts, double[] reference, int refCount) {
        MathContext cont = MathContext.DECIMAL128;
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        this._data.sparseToDense();
        double[] values = this._data.getDenseBlockValues();
        BigDecimal tmp = BigDecimal.ONE;
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                double v;
                if ((v = values[off++] + reference[j]) == 0.0) {
                    ret[0] = 0.0;
                    return;
                }
                tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
            }
        }
        for (int x = 0; x < reference.length; ++x) {
            tmp = tmp.multiply(new BigDecimal(reference[x]).pow(refCount, cont), cont);
        }
        if (Math.abs(tmp.doubleValue()) == 0.0) {
            ret[0] = 0.0;
        } else if (!Double.isInfinite(ret[0])) {
            ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
        }
    }

    @Override
    public CM_COV_Object centralMoment(CM_COV_Object ret, ValueFunction fn, int[] counts, int nRows) {
        if (this._data.isInSparseFormat()) {
            throw new DMLCompressionException("The dictionary should not be sparse with one column");
        }
        double[] vals = this._data.getDenseBlockValues();
        for (int i = 0; i < vals.length; ++i) {
            fn.execute(ret, vals[i], counts[i]);
        }
        return ret;
    }

    @Override
    public CM_COV_Object centralMomentWithReference(CM_COV_Object ret, ValueFunction fn, int[] counts, double reference, int nRows) {
        if (this._data.isInSparseFormat()) {
            throw new DMLCompressionException("The dictionary should not be sparse with one column");
        }
        double[] vals = this._data.getDenseBlockValues();
        for (int i = 0; i < vals.length; ++i) {
            fn.execute(ret, vals[i] + reference, counts[i]);
        }
        return ret;
    }

    @Override
    public ADictionary rexpandCols(int max, boolean ignore, boolean cast, int nCol) {
        MatrixBlock ex = LibMatrixReorg.rexpand(this._data, new MatrixBlock(), max, false, cast, ignore, 1);
        if (ex.isEmpty()) {
            return null;
        }
        return new MatrixBlockDictionary(ex, max);
    }

    @Override
    public ADictionary rexpandColsWithReference(int max, boolean ignore, boolean cast, double reference) {
        return this.applyScalarOp(new LeftScalarOperator(Plus.getPlusFnObject(), reference)).rexpandCols(max, ignore, cast, 1);
    }

    @Override
    public double getSparsity() {
        return this._data.getSparsity();
    }

    @Override
    public void multiplyScalar(double v, double[] ret, int off, int dictIdx, int[] cols) {
        if (this._data.isInSparseFormat()) {
            this.multiplyScalarSparse(v, ret, off, dictIdx, cols);
        } else {
            this.multiplyScalarDense(v, ret, off, dictIdx, cols);
        }
    }

    private void multiplyScalarSparse(double v, double[] ret, int off, int dictIdx, int[] cols) {
        SparseBlock sb = this._data.getSparseBlock();
        if (sb.isEmpty(dictIdx)) {
            return;
        }
        int apos = sb.pos(dictIdx);
        int alen = sb.size(dictIdx) + apos;
        int[] aix = sb.indexes(dictIdx);
        double[] aval = sb.values(dictIdx);
        for (int i = apos; i < alen; ++i) {
            int n = off + cols[aix[i]];
            ret[n] = ret[n] + v * aval[i];
        }
    }

    private void multiplyScalarDense(double v, double[] ret, int off, int dictIdx, int[] cols) {
        double[] dV = this._data.getDenseBlockValues();
        int offD = dictIdx * cols.length;
        for (int i = 0; i < cols.length; ++i) {
            int n = off + cols[i];
            ret[n] = ret[n] + v * dV[offD + i];
        }
    }

    @Override
    protected void TSMMWithScaling(int[] counts, int[] rows, int[] cols, MatrixBlock ret) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.TSMMDictsSparseWithScaling(this._data.getSparseBlock(), rows, cols, counts, ret);
        } else {
            DictLibMatrixMult.TSMMDictsDenseWithScaling(this._data.getDenseBlockValues(), rows, cols, counts, ret);
        }
    }

    @Override
    protected void MMDict(ADictionary right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            right.MMDictSparse(this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            right.MMDictDense(this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    protected void MMDictDense(double[] left, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsDenseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMDictsDenseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    protected void MMDictSparse(SparseBlock left, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsSparseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMDictsSparseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    protected void TSMMToUpperTriangle(ADictionary right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            right.TSMMToUpperTriangleSparse(this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            right.TSMMToUpperTriangleDense(this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    protected void TSMMToUpperTriangleDense(double[] left, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMToUpperTriangleDenseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleDenseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    protected void TSMMToUpperTriangleSparse(SparseBlock left, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMToUpperTriangleSparseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleSparseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    protected void TSMMToUpperTriangleScaling(ADictionary right, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            right.TSMMToUpperTriangleSparseScaling(this._data.getSparseBlock(), rowsLeft, colsRight, scale, result);
        } else {
            right.TSMMToUpperTriangleDenseScaling(this._data.getDenseBlockValues(), rowsLeft, colsRight, scale, result);
        }
    }

    @Override
    protected void TSMMToUpperTriangleDenseScaling(double[] left, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.TSMMToUpperTriangleDenseSparseScaling(left, this._data.getSparseBlock(), rowsLeft, colsRight, scale, result);
        } else {
            DictLibMatrixMult.TSMMToUpperTriangleDenseDenseScaling(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, scale, result);
        }
    }

    @Override
    protected void TSMMToUpperTriangleSparseScaling(SparseBlock left, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.TSMMToUpperTriangleSparseSparseScaling(left, this._data.getSparseBlock(), rowsLeft, colsRight, scale, result);
        } else {
            DictLibMatrixMult.TSMMToUpperTriangleSparseDenseScaling(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, scale, result);
        }
    }
}

