/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5;

import java.io.Serializable;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.ImmutableSessionPersistedObject;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.PageRenderLinkSource;

@ImmutableSessionPersistedObject
public class PageCallback
implements Serializable {
    private static final long serialVersionUID = -8067619978636824702L;
    private String pageName;
    private String[] activationContext;

    public PageCallback(String pageName, String[] activationContext) {
        assert (InternalUtils.isNonBlank((String)pageName));
        this.pageName = pageName;
        assert (activationContext != null);
        this.activationContext = activationContext;
    }

    public PageCallback(String pageName, EventContext activationContext) {
        this(pageName, activationContext.toStrings());
    }

    public PageCallback(String pageName) {
        this(pageName, InternalConstants.EMPTY_STRING_ARRAY);
    }

    public String getPageName() {
        return this.pageName;
    }

    public String toString() {
        if (this.hasActivationContext()) {
            return String.format("PageCallback[%s %s]", this.pageName, this.activationContextDescription());
        }
        return String.format("PageCallback[%s]", this.pageName);
    }

    protected final boolean hasActivationContext() {
        return this.activationContext.length > 0;
    }

    protected final String activationContextDescription() {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (String c : this.activationContext) {
            builder.append(sep);
            builder.append(c);
            sep = "/";
        }
        return builder.toString();
    }

    public Link toLink(PageRenderLinkSource linkSource) {
        return linkSource.createPageRenderLinkWithContext(this.pageName, (Object[])this.activationContext);
    }
}

