/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collection;
import java.util.Map;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.BeanBlockContribution;
import org.apache.tapestry5.services.BeanBlockOverrideSource;

public class BeanBlockOverrideSourceImpl
implements BeanBlockOverrideSource {
    private final RequestPageCache pageCache;
    private final Map<String, BeanBlockContribution> display = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, BeanBlockContribution> edit = CollectionFactory.newCaseInsensitiveMap();

    public BeanBlockOverrideSourceImpl(RequestPageCache pageCache, Collection<BeanBlockContribution> configuration) {
        this.pageCache = pageCache;
        for (BeanBlockContribution contribution : configuration) {
            String dataType;
            Map<String, BeanBlockContribution> map = contribution.isEdit() ? this.edit : this.display;
            BeanBlockContribution previousValue = map.put(dataType = contribution.getDataType(), contribution);
            if (previousValue == null) continue;
            throw new IllegalArgumentException("The BeanBlockOverrideSource configuration contains multiple " + (contribution.isEdit() ? "edit" : "display") + " block overrides for data type '" + dataType + "'.");
        }
    }

    @Override
    public boolean hasDisplayBlock(String datatype) {
        return this.display.containsKey(datatype);
    }

    @Override
    public Block getDisplayBlock(String datatype) {
        return this.toBlock(this.display.get(datatype));
    }

    private Block toBlock(BeanBlockContribution contribution) {
        if (contribution == null) {
            return null;
        }
        Page page = this.pageCache.get(contribution.getPageName());
        return page.getRootElement().getBlock(contribution.getBlockId());
    }

    @Override
    public Block getEditBlock(String datatype) {
        return this.toBlock(this.edit.get(datatype));
    }
}

