/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Request;

public class RequestOperationTracker
implements ComponentRequestFilter {
    private final OperationTracker tracker;
    private final Request request;

    public RequestOperationTracker(OperationTracker tracker, Request request) {
        this.tracker = tracker;
        this.request = request;
    }

    @Override
    public void handleComponentEvent(final ComponentEventRequestParameters parameters, final ComponentRequestHandler handler) throws IOException {
        String componentId = parameters.getNestedComponentId().equals("") ? parameters.getContainingPageName() : parameters.getContainingPageName() + ":" + parameters.getNestedComponentId();
        this.tracker.perform(String.format("Handling %s '%s' component event request for %s.", this.request.isXHR() ? "Ajax" : "traditional", parameters.getEventType(), componentId), (IOOperation)new IOOperation<Void>(){

            public Void perform() throws IOException {
                handler.handleComponentEvent(parameters);
                return null;
            }
        });
    }

    @Override
    public void handlePageRender(final PageRenderRequestParameters parameters, final ComponentRequestHandler handler) throws IOException {
        final Holder holder = Holder.create();
        this.tracker.run("Handling page render request for page " + parameters.getLogicalPageName(), new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handlePageRender(parameters);
                }
                catch (IOException e) {
                    holder.put(e);
                }
            }
        });
        if (holder.hasValue()) {
            throw (IOException)holder.get();
        }
    }
}

