/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.IOException;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.AssetPathConverter;
import org.apache.tapestry5.services.BaseURLSource;
import org.apache.tapestry5.services.PathConstructor;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.assets.AssetPathConstructor;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.StreamableResource;

public class AssetPathConstructorImpl
implements AssetPathConstructor {
    private final Request request;
    private final String prefix;
    private final BaseURLSource baseURLSource;
    private final AssetPathConverter pathConverter;
    private final boolean fullyQualified;

    public AssetPathConstructorImpl(Request request, BaseURLSource baseURLSource, @Symbol(value="tapestry.asset-url-fully-qualified") boolean fullyQualified, @Symbol(value="tapestry.asset-path-prefix") String uncompressedAssetPrefix, PathConstructor pathConstructor, AssetPathConverter pathConverter) {
        this.request = request;
        this.baseURLSource = baseURLSource;
        this.fullyQualified = fullyQualified;
        this.pathConverter = pathConverter;
        this.prefix = pathConstructor.constructClientPath(uncompressedAssetPrefix, "");
    }

    @Override
    public String constructAssetPath(String virtualFolder, String path, StreamableResource resource) throws IOException {
        assert (InternalUtils.isNonBlank((String)path));
        assert (InternalUtils.isNonBlank((String)virtualFolder));
        StringBuilder builder = new StringBuilder();
        if (this.fullyQualified) {
            builder.append(this.baseURLSource.getBaseURL(this.request.isSecure()));
        }
        builder.append(this.prefix);
        builder.append(virtualFolder);
        builder.append('/');
        if (resource.getCompression() == CompressionStatus.COMPRESSED) {
            builder.append('z');
        }
        builder.append(resource.getChecksum());
        builder.append('/');
        builder.append(path);
        return this.pathConverter.convertAssetPath(builder.toString());
    }
}

