/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.compatibility;

import java.util.Map;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ComponentClasses;
import org.apache.tapestry5.services.ComponentMessages;
import org.apache.tapestry5.services.ComponentTemplates;
import org.apache.tapestry5.services.InvalidationEventHub;
import org.apache.tapestry5.services.compatibility.DeprecationWarning;
import org.slf4j.Logger;

public class DeprecationWarningImpl
implements DeprecationWarning {
    private final Logger logger;
    private final AlertManager alertManager;
    private final Map<Object, Boolean> deprecations = CollectionFactory.newConcurrentMap();

    public DeprecationWarningImpl(Logger logger, AlertManager alertManager) {
        this.logger = logger;
        this.alertManager = alertManager;
    }

    @Override
    public void componentParameter(ComponentResources resources, String parameterName, String message) {
        assert (resources != null);
        assert (InternalUtils.isNonBlank((String)parameterName));
        assert (InternalUtils.isNonBlank((String)message));
        ParameterDeprecationKey key = new ParameterDeprecationKey(resources.getCompleteId(), parameterName);
        if (this.deprecations.containsKey(key)) {
            return;
        }
        this.deprecations.put(key, true);
        this.logMessage(resources, parameterName, message);
    }

    @Override
    public void ignoredComponentParameters(ComponentResources resources, String ... parameterNames) {
        assert (resources != null);
        for (String name : parameterNames) {
            if (!resources.isBound(name)) continue;
            this.componentParameter(resources, name, "This parameter is ignored and may be removed in a future release.");
        }
    }

    @Override
    public void componentParameterValue(ComponentResources resources, String parameterName, Object parameterValue, String message) {
        assert (resources != null);
        assert (InternalUtils.isNonBlank((String)parameterName));
        assert (InternalUtils.isNonBlank((String)message));
        ParameterValueDeprecationKey key = new ParameterValueDeprecationKey(resources.getCompleteId(), parameterName, parameterValue);
        if (this.deprecations.containsKey(key)) {
            return;
        }
        this.deprecations.put(key, true);
        this.logMessage(resources, parameterName, message);
    }

    private void logMessage(ComponentResources resources, String parameterName, String message) {
        String text = String.format("Component %s, parameter %s: %s\n(at %s)", resources.getCompleteId(), parameterName, message, resources.getLocation());
        this.logger.error(text);
        this.alertManager.warn(text);
    }

    public void setupClearDeprecationsWhenInvalidated(@ComponentClasses InvalidationEventHub componentClassesHub, @ComponentMessages InvalidationEventHub messagesHub, @ComponentTemplates InvalidationEventHub templatesHub) {
        componentClassesHub.clearOnInvalidation(this.deprecations);
        messagesHub.clearOnInvalidation(this.deprecations);
        templatesHub.clearOnInvalidation(this.deprecations);
    }

    static class ParameterValueDeprecationKey {
        final String completeId;
        final String parameterName;
        final Object value;

        ParameterValueDeprecationKey(String completeId, String parameterName, Object value) {
            this.completeId = completeId;
            this.parameterName = parameterName;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterValueDeprecationKey that = (ParameterValueDeprecationKey)o;
            if (!this.completeId.equals(that.completeId)) {
                return false;
            }
            if (!this.parameterName.equals(that.parameterName)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.completeId.hashCode();
            result = 31 * result + this.parameterName.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    static class ParameterDeprecationKey {
        final String completeId;
        final String parameterName;

        ParameterDeprecationKey(String completeId, String parameterName) {
            this.completeId = completeId;
            this.parameterName = parameterName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterDeprecationKey that = (ParameterDeprecationKey)o;
            if (!this.completeId.equals(that.completeId)) {
                return false;
            }
            return this.parameterName.equals(that.parameterName);
        }

        public int hashCode() {
            int result = this.completeId.hashCode();
            result = 31 * result + this.parameterName.hashCode();
            return result;
        }
    }
}

