/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.mongodb.modules;

import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import org.apache.tapestry5.internal.mongodb.MongoDBImpl;
import org.apache.tapestry5.internal.mongodb.MongoDBSourceImpl;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.Coercion;
import org.apache.tapestry5.ioc.services.CoercionTuple;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.apache.tapestry5.mongodb.MongoDB;
import org.apache.tapestry5.mongodb.MongoDBSource;
import org.slf4j.Logger;

public class MongodbModule {
    public static void bind(ServiceBinder binder) {
        binder.bind(MongoDBSource.class, MongoDBSourceImpl.class);
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"tapestry.mongodb.conns-per-host", (Object)"10");
        configuration.add((Object)"tapestry.mongodb.write_concern", (Object)"ACKNOWLEDGED");
        configuration.add((Object)"tapestry.mongodb.read_preference", (Object)"PRIMARY");
        configuration.add((Object)"tapestry.mongodb.consistent_request", (Object)"false");
        configuration.add((Object)"tapestry.mongodb.secure_mode", (Object)"false");
        configuration.add((Object)"tapestry.mongodb.db_username", (Object)"");
        configuration.add((Object)"tapestry.mongodb.db_password", (Object)"");
    }

    @Scope(value="perthread")
    public static MongoDB buildMongoDB(Logger logger, MongoDBSource mongoDBSource, PerthreadManager perthreadManager, @Symbol(value="tapestry.mongodb.default_db_name") String defaultDbName, @Symbol(value="tapestry.mongodb.consistent_request") boolean consistentRequest, @Symbol(value="tapestry.mongodb.secure_mode") boolean secureMode, @Symbol(value="tapestry.mongodb.db_username") String dbUsername, @Symbol(value="tapestry.mongodb.db_password") String dbPassword) {
        MongoDBImpl mongoDB = new MongoDBImpl(logger, mongoDBSource, defaultDbName, consistentRequest, secureMode, dbUsername, dbPassword);
        perthreadManager.addThreadCleanupListener((ThreadCleanupListener)mongoDB);
        return mongoDB;
    }

    public static void contributeTypeCoercer(Configuration<CoercionTuple> configuration) {
        configuration.add((Object)new CoercionTuple(String.class, WriteConcern.class, (Coercion)new Coercion<String, WriteConcern>(){

            public WriteConcern coerce(String input) {
                if (input.equalsIgnoreCase("FSYNC_SAFE")) {
                    return WriteConcern.FSYNC_SAFE;
                }
                if (input.equalsIgnoreCase("JOURNAL_SAFE")) {
                    return WriteConcern.JOURNAL_SAFE;
                }
                if (input.equalsIgnoreCase("MAJORITY")) {
                    return WriteConcern.MAJORITY;
                }
                if (input.equalsIgnoreCase("NONE")) {
                    return WriteConcern.NONE;
                }
                if (input.equalsIgnoreCase("REPLICAS_SAFE")) {
                    return WriteConcern.REPLICAS_SAFE;
                }
                if (input.equalsIgnoreCase("SAFE")) {
                    return WriteConcern.SAFE;
                }
                if (input.equalsIgnoreCase("NORMAL")) {
                    return WriteConcern.NORMAL;
                }
                return WriteConcern.ACKNOWLEDGED;
            }
        }));
        configuration.add((Object)new CoercionTuple(String.class, ReadPreference.class, (Coercion)new Coercion<String, ReadPreference>(){

            public ReadPreference coerce(String input) {
                if (input.equalsIgnoreCase("SECONDARY")) {
                    return ReadPreference.secondary();
                }
                return ReadPreference.primary();
            }
        }));
    }
}

