/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.Map;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.internal.AbstractConfigurationImpl;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.MappedConfigurationOverride;
import org.apache.tapestry5.ioc.internal.TypeCoercerProxy;

public class ValidatingMappedConfigurationWrapper<K, V>
extends AbstractConfigurationImpl<V>
implements MappedConfiguration<K, V> {
    private final TypeCoercerProxy typeCoercer;
    private final Map<K, V> map;
    private final Map<K, MappedConfigurationOverride<K, V>> overrides;
    private final String serviceId;
    private final ContributionDef contributionDef;
    private final Class<K> expectedKeyType;
    private final Class<V> expectedValueType;
    private final Map<K, ContributionDef> keyToContributor;

    public ValidatingMappedConfigurationWrapper(Class<V> expectedValueType, ObjectLocator locator, TypeCoercerProxy typeCoercer, Map<K, V> map, Map<K, MappedConfigurationOverride<K, V>> overrides, String serviceId, ContributionDef contributionDef, Class<K> expectedKeyType, Map<K, ContributionDef> keyToContributor) {
        super(expectedValueType, locator);
        this.typeCoercer = typeCoercer;
        this.map = map;
        this.overrides = overrides;
        this.serviceId = serviceId;
        this.contributionDef = contributionDef;
        this.expectedKeyType = expectedKeyType;
        this.expectedValueType = expectedValueType;
        this.keyToContributor = keyToContributor;
    }

    public void add(K key, V value) {
        this.validateKey(key);
        if (value == null) {
            throw new NullPointerException(IOCMessages.contributionWasNull(this.serviceId));
        }
        V coerced = this.typeCoercer.coerce(value, this.expectedValueType);
        ContributionDef existing = this.keyToContributor.get(key);
        if (existing != null) {
            throw new IllegalArgumentException(IOCMessages.contributionDuplicateKey(this.serviceId, key, existing));
        }
        this.map.put(key, coerced);
        this.keyToContributor.put(key, this.contributionDef);
    }

    private void validateKey(K key) {
        if (key == null) {
            throw new NullPointerException(IOCMessages.contributionKeyWasNull(this.serviceId));
        }
        if (!this.expectedKeyType.isInstance(key)) {
            throw new IllegalArgumentException(IOCMessages.contributionWrongKeyType(this.serviceId, key.getClass(), this.expectedKeyType));
        }
    }

    public void addInstance(K key, Class<? extends V> clazz) {
        this.add(key, this.instantiate(clazz));
    }

    public void override(K key, V value) {
        this.validateKey(key);
        Object coerced = value == null ? null : (Object)this.typeCoercer.coerce(value, this.expectedValueType);
        MappedConfigurationOverride<K, V> existing = this.overrides.get(key);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Contribution key %s has already been overridden (by %s).", key, existing.getContribDef()));
        }
        this.overrides.put(key, new MappedConfigurationOverride<K, Object>(this.contributionDef, this.map, key, coerced));
    }

    public void overrideInstance(K key, Class<? extends V> clazz) {
        this.override(key, this.instantiate(clazz));
    }
}

