/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.clojure;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import clojure.lang.Symbol;
import java.lang.reflect.Method;
import org.apache.tapestry5.clojure.ClojureBuilder;
import org.apache.tapestry5.clojure.MethodToFunctionSymbolMapper;
import org.apache.tapestry5.clojure.Namespace;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;

public class ClojureBuilderImpl
implements ClojureBuilder {
    private final PlasticProxyFactory proxyFactory;
    private final MethodToFunctionSymbolMapper mapper;
    private final OperationTracker tracker;
    private final IFn REQUIRE = Clojure.var((Object)"clojure.core", (Object)"require");

    public ClojureBuilderImpl(@Builtin PlasticProxyFactory proxyFactory, MethodToFunctionSymbolMapper mapper, OperationTracker tracker) {
        this.proxyFactory = proxyFactory;
        this.mapper = mapper;
        this.tracker = tracker;
    }

    @Override
    public <T> T build(final Class<T> interfaceType) {
        assert (interfaceType != null);
        assert (interfaceType.isInterface());
        Namespace annotation = interfaceType.getAnnotation(Namespace.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Interface type %s does not have the Namespace annotation.", interfaceType.getName()));
        }
        final String namespace = annotation.value();
        ClassInstantiator instantiator = this.proxyFactory.createProxy(interfaceType, new PlasticClassTransformer(){

            public void transform(PlasticClass plasticClass) {
                for (Method m : interfaceType.getMethods()) {
                    this.bridgeToClojure(plasticClass, m);
                }
            }

            private void bridgeToClojure(final PlasticClass plasticClass, final Method method) {
                final MethodDescription desc = new MethodDescription(method);
                if (method.getReturnType() == Void.TYPE) {
                    throw new IllegalArgumentException(String.format("Method %s may not be void when bridging to Clojure functions.", desc));
                }
                final Symbol symbol = ClojureBuilderImpl.this.mapper.mapMethod(namespace, method);
                ClojureBuilderImpl.this.tracker.run(String.format("Mapping %s method %s to Clojure function %s", interfaceType.getName(), desc.toShortString(), symbol.toString()), new Runnable(){

                    @Override
                    public void run() {
                        Symbol namespaceSymbol = Symbol.create((String)symbol.getNamespace());
                        ClojureBuilderImpl.this.REQUIRE.invoke((Object)namespaceSymbol);
                        IFn clojureFunction = Clojure.var((Object)symbol);
                        final PlasticField fnField = plasticClass.introduceField(IFn.class, method.getName() + "IFn").inject((Object)clojureFunction);
                        plasticClass.introduceMethod(desc).changeImplementation(new InstructionBuilderCallback(){

                            public void doBuild(InstructionBuilder builder) {
                                this.bridgeToClojure(builder, desc, fnField);
                            }
                        });
                    }
                });
            }

            private void bridgeToClojure(InstructionBuilder builder, MethodDescription description, PlasticField ifnField) {
                builder.loadThis().getField(ifnField);
                int count = description.argumentTypes.length;
                Class[] invokeParameterTypes = new Class[count];
                for (int i = 0; i < count; ++i) {
                    invokeParameterTypes[i] = Object.class;
                    builder.loadArgument(i).boxPrimitive(description.argumentTypes[i]);
                }
                Method ifnMethod = null;
                try {
                    ifnMethod = IFn.class.getMethod("invoke", invokeParameterTypes);
                }
                catch (NoSuchMethodException ex) {
                    throw new RuntimeException(String.format("Unable to find correct IFn.invoke() method: %s", ExceptionUtils.toMessage((Throwable)ex)), ex);
                }
                builder.invoke(ifnMethod);
                builder.castOrUnbox(description.returnType);
                builder.returnResult();
            }
        });
        return (T)instantiator.newInstance();
    }
}

