/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services;

import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public final class ComponentEventRequestParameters {
    private final String activePageName;
    private final String containingPageName;
    private final String nestedComponentId;
    private final String eventType;
    private final EventContext pageActivationContext;
    private final EventContext eventContext;

    public ComponentEventRequestParameters(String activePageName, String containingPageName, String nestedComponentId, String eventType, EventContext pageActivationContext, EventContext eventContext) {
        assert (InternalUtils.isNonBlank((String)activePageName));
        assert (InternalUtils.isNonBlank((String)containingPageName));
        assert (nestedComponentId != null);
        assert (InternalUtils.isNonBlank((String)eventType));
        assert (pageActivationContext != null);
        assert (eventContext != null);
        this.activePageName = activePageName;
        this.containingPageName = containingPageName;
        this.nestedComponentId = nestedComponentId;
        this.eventType = eventType;
        this.pageActivationContext = pageActivationContext;
        this.eventContext = eventContext;
    }

    public String toString() {
        return String.format("ComponentEventParameters[page=%s component=%s:%s event=%s]", this.activePageName, this.containingPageName, this.nestedComponentId, this.eventType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentEventRequestParameters that = (ComponentEventRequestParameters)o;
        if (!this.activePageName.equals(that.activePageName)) {
            return false;
        }
        if (!this.containingPageName.equals(that.containingPageName)) {
            return false;
        }
        if (!this.eventType.equals(that.eventType)) {
            return false;
        }
        if (!this.nestedComponentId.equals(that.nestedComponentId)) {
            return false;
        }
        if (!TapestryInternalUtils.isEqual(this.eventContext, that.eventContext)) {
            return false;
        }
        return TapestryInternalUtils.isEqual(this.pageActivationContext, that.pageActivationContext);
    }

    public String getActivePageName() {
        return this.activePageName;
    }

    public String getContainingPageName() {
        return this.containingPageName;
    }

    public String getNestedComponentId() {
        return this.nestedComponentId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public EventContext getPageActivationContext() {
        return this.pageActivationContext;
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }
}

