/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.func;

import org.apache.tapestry5.func.AbstractFlow;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.LazyContinuation;
import org.apache.tapestry5.func.LazyFunction;
import org.apache.tapestry5.func.LazyValue;

class LazyFlow<T>
extends AbstractFlow<T> {
    private LazyFunction<T> lazyFunction;
    private boolean empty;
    private LazyValue<T> lazyFirst;
    private Flow<T> rest;
    private T first;

    public LazyFlow(LazyFunction<T> lazyFunction) {
        this.lazyFunction = lazyFunction;
    }

    @Override
    public synchronized T first() {
        this.resolve();
        if (this.lazyFirst != null) {
            this.first = this.lazyFirst.get();
            this.lazyFirst = null;
        }
        return this.first;
    }

    @Override
    public synchronized boolean isEmpty() {
        this.resolve();
        return this.empty;
    }

    @Override
    public synchronized Flow<T> rest() {
        this.resolve();
        return this.rest;
    }

    private synchronized void resolve() {
        if (this.lazyFunction == null) {
            return;
        }
        LazyContinuation<T> continuation = this.lazyFunction.next();
        if (continuation == null) {
            this.empty = true;
            this.rest = F.emptyFlow();
        } else {
            this.lazyFirst = continuation.nextValue();
            this.rest = new LazyFlow<T>(continuation.nextFunction());
        }
        this.lazyFunction = null;
    }
}

