/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.dom;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.util.PrintOutCollector;

public abstract class Node {
    Element container;
    Node nextSibling;

    protected Node(Element container) {
        this.container = container;
    }

    public Element getContainer() {
        return this.container;
    }

    public Document getDocument() {
        return this.container.getDocument();
    }

    public String toString() {
        PrintOutCollector collector = new PrintOutCollector();
        this.toMarkup(collector.getPrintWriter());
        return collector.getPrintOut();
    }

    public void toMarkup(PrintWriter writer) {
        this.toMarkup(this.getDocument(), writer, this.getNamespaceURIToPrefix());
    }

    protected Map<String, String> getNamespaceURIToPrefix() {
        return this.container.getNamespaceURIToPrefix();
    }

    abstract void toMarkup(Document var1, PrintWriter var2, Map<String, String> var3);

    public Node moveBefore(Element element) {
        this.validateElement(element);
        this.remove();
        element.container.insertChildBefore(element, this);
        return this;
    }

    public Node moveAfter(Element element) {
        this.validateElement(element);
        this.remove();
        element.container.insertChildAfter(element, this);
        return this;
    }

    public Node moveToTop(Element element) {
        this.validateElement(element);
        this.remove();
        element.insertChildAt(0, this);
        return this;
    }

    public Node moveToBottom(Element element) {
        this.validateElement(element);
        this.remove();
        element.addChild(this);
        return this;
    }

    private void validateElement(Element element) {
        assert (element != null);
        for (Element search = element; search != null; search = search.getContainer()) {
            if (!search.equals(this)) continue;
            throw new IllegalArgumentException("Unable to move a node relative to itself.");
        }
    }

    public void remove() {
        this.container.remove(this);
        this.container = null;
    }

    public Element wrap(String elementName, String ... namesAndValues) {
        int index = this.container.indexOfNode(this);
        Element element = this.container.elementAt(index, elementName, namesAndValues);
        this.moveToTop(element);
        return element;
    }
}

