/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry5.services.ComponentOverride;
import org.slf4j.Logger;

public class ComponentOverrideImpl
implements ComponentOverride {
    private final Map<String, Class> nameToClass;

    public ComponentOverrideImpl(Map<Class, Class> contributions, Logger logger) {
        Map<Class, Class> replacements = Collections.unmodifiableMap(contributions);
        HashMap<String, Class> nameToClass = new HashMap<String, Class>();
        int maxLength = 0;
        for (Class clazz : contributions.keySet()) {
            String name = clazz.getName();
            if (name.length() > maxLength) {
                maxLength = name.length();
            }
            nameToClass.put(name, contributions.get(clazz));
        }
        this.nameToClass = Collections.unmodifiableMap(nameToClass);
        if (replacements.size() > 0 && logger.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder(1000);
            String format = "%" + maxLength + "s: %s\n";
            builder.append("Component replacements (including components, pages and mixins):\n");
            ArrayList names = new ArrayList(nameToClass.keySet());
            Collections.sort(names);
            for (String name : names) {
                builder.append(String.format(format, name, ((Class)nameToClass.get(name)).getName()));
            }
            logger.info(builder.toString());
        }
    }

    @Override
    public boolean hasReplacements() {
        return !this.nameToClass.isEmpty();
    }

    @Override
    public Class getReplacement(String className) {
        return this.nameToClass.get(className);
    }
}

