/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.AvailableValues;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.UnknownValueException;
import org.apache.tapestry5.services.AssetAlias;
import org.apache.tapestry5.services.ClasspathAssetAliasManager;

public class ClasspathAssetAliasManagerImpl
implements ClasspathAssetAliasManager {
    private final Map<String, String> aliasToPathPrefix = CollectionFactory.newMap();
    private final Map<String, String> pathPrefixToAlias = CollectionFactory.newMap();
    private final List<String> sortedPathPrefixes;

    public ClasspathAssetAliasManagerImpl(Map<String, String> configuration) {
        for (Map.Entry<String, String> e : configuration.entrySet()) {
            String alias = this.verify("folder name", e.getKey());
            String path = this.verify("path", e.getValue());
            this.aliasToPathPrefix.put(alias, path);
            this.pathPrefixToAlias.put(path, alias);
        }
        Comparator<String> sortDescendingByLength = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        };
        this.sortedPathPrefixes = CollectionFactory.newList(this.aliasToPathPrefix.values());
        Collections.sort(this.sortedPathPrefixes, sortDescendingByLength);
    }

    private String verify(String name, String input) {
        if (input.startsWith("/") || input.endsWith("/")) {
            throw new RuntimeException(String.format("Contribution of %s '%s' is invalid as it may not start with or end with a slash.", name, input));
        }
        return input;
    }

    @Override
    public AssetAlias extractAssetAlias(Resource resource) {
        String resourcePath = resource.getPath();
        for (String pathPrefix : this.sortedPathPrefixes) {
            if (!resourcePath.startsWith(pathPrefix)) continue;
            if (pathPrefix.length() == resourcePath.length()) {
                throw new IllegalArgumentException(String.format("Resource path '%s' is not valid as it is mapped as virtual folder '%s'.", resourcePath, this.pathPrefixToAlias.get(pathPrefix)));
            }
            if (resourcePath.charAt(pathPrefix.length()) != '/') continue;
            String virtualFolder = this.pathPrefixToAlias.get(pathPrefix);
            String path = resourcePath.substring(pathPrefix.length() + 1);
            return new AssetAlias(virtualFolder, path);
        }
        throw new UnknownValueException(String.format("Unable to create a client URL for classpath resource %s: The resource path was not within an aliased path.", resourcePath), new AvailableValues("Aliased paths", this.aliasToPathPrefix.values()));
    }

    @Override
    public Map<String, String> getMappings() {
        return Collections.unmodifiableMap(this.aliasToPathPrefix);
    }
}

