/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.TapestryMarkers;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.runtime.Event;
import org.slf4j.Logger;

public class EventImpl
implements Event {
    private boolean aborted;
    private String methodDescription;
    private final ComponentEventCallback handler;
    private final Logger logger;
    private final boolean debugEnabled;
    protected final OperationTracker tracker;

    public EventImpl(ComponentEventCallback handler, Logger logger, OperationTracker tracker) {
        this.tracker = tracker;
        assert (handler != null);
        this.handler = handler;
        this.logger = logger;
        this.debugEnabled = logger.isDebugEnabled();
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void setMethodDescription(String methodDescription) {
        if (this.debugEnabled) {
            this.logger.debug(TapestryMarkers.EVENT_HANDLER_METHOD, "Invoking: " + methodDescription);
        }
        this.methodDescription = methodDescription;
    }

    @Override
    public boolean storeResult(final Object result) {
        if (this.aborted) {
            throw new IllegalStateException(String.format("Can not store result from invoking method %s, because an event result value has already been obtained from some other event handler method.", this.methodDescription));
        }
        if (result != null) {
            boolean handleResult = (Boolean)this.tracker.invoke("Handling result from method " + this.methodDescription + '.', (Invokable)new Invokable<Boolean>(){

                public Boolean invoke() {
                    return EventImpl.this.handler.handleResult(result);
                }
            });
            this.aborted |= handleResult;
        }
        return this.aborted;
    }

    protected String getMethodDescription() {
        return this.methodDescription;
    }
}

