/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.PathConstructor;

public class PathConstructorImpl
implements PathConstructor {
    private final String clientPrefix;
    private final String dispatchPrefix;

    public PathConstructorImpl(@Symbol(value="tapestry.context-path") String contextPath, @Symbol(value="tapestry.application-folder") String applicationFolder) {
        StringBuilder b = new StringBuilder("/");
        if (applicationFolder.length() > 0) {
            b.append(applicationFolder);
            b.append('/');
        }
        this.dispatchPrefix = b.toString();
        this.clientPrefix = (contextPath.equals("/") ? "" : contextPath) + this.dispatchPrefix;
    }

    @Override
    public String constructClientPath(String ... terms) {
        return this.build(this.clientPrefix, terms);
    }

    @Override
    public String constructDispatchPath(String ... terms) {
        return this.build(this.dispatchPrefix, terms);
    }

    private String build(String prefix, String ... terms) {
        StringBuilder b = new StringBuilder(prefix);
        String sep = "";
        for (String term : terms) {
            b.append(sep);
            b.append(term);
            sep = "/";
        }
        return b.toString();
    }
}

