/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.net.URL;
import org.apache.tapestry5.http.services.Context;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RequestFilter;
import org.apache.tapestry5.http.services.RequestHandler;
import org.apache.tapestry5.http.services.Response;

public class StaticFilesFilter
implements RequestFilter {
    private final Context context;

    public StaticFilesFilter(Context context) {
        this.context = context;
    }

    public boolean service(Request request, Response response, RequestHandler handler) throws IOException {
        URL url;
        int dotx;
        String path = request.getPath();
        if (path.equals("/favicon.ico")) {
            return false;
        }
        if (!path.contains(":") && (dotx = path.lastIndexOf(".")) > 0 && (url = this.context.getResource(path)) != null) {
            String suffix = path.substring(dotx + 1);
            if (suffix.equalsIgnoreCase("tml")) {
                response.sendError(403, String.format("URI %s may not be accessed remotely.", path));
                return true;
            }
            return false;
        }
        return handler.service(request, response);
    }
}

