/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.internal.services.AttributeInfo;
import org.apache.tapestry5.internal.services.DTDData;
import org.apache.tapestry5.internal.services.NamespaceMapping;
import org.apache.tapestry5.internal.services.XMLToken;
import org.apache.tapestry5.internal.services.XMLTokenType;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.LocationImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLTokenStream {
    public static final String TRANSITIONAL_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    private static final DTDData HTML5_DTD_DATA = new DTDData("html", null, null);
    private int cursor = -1;
    private final List<XMLToken> tokens = CollectionFactory.newList();
    private final Resource resource;
    private final Map<String, URL> publicIdToURL;
    private Location exceptionLocation;
    private boolean html5DTD;
    private boolean ignoreDTD;
    private int lineOffset;

    public XMLTokenStream(Resource resource, Map<String, URL> publicIdToURL) {
        this.resource = resource;
        this.publicIdToURL = publicIdToURL;
    }

    public void parse() throws SAXException, IOException {
        SaxHandler handler = new SaxHandler();
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(handler);
        reader.setEntityResolver(handler);
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        InputStream stream = null;
        try {
            stream = this.openStream();
            reader.parse(new InputSource(stream));
        }
        catch (IOException ex) {
            this.exceptionLocation = handler.getLocation();
            throw ex;
        }
        catch (SAXException ex) {
            this.exceptionLocation = handler.getLocation();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.exceptionLocation = handler.getLocation();
            throw ex;
        }
        finally {
            InternalUtils.close((Closeable)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream openStream() throws IOException {
        InputStream rawStream = this.resource.openStream();
        String transformationEncoding = "UTF8";
        InputStreamReader rawReader = new InputStreamReader(rawStream, transformationEncoding);
        LineNumberReader reader = new LineNumberReader(rawReader);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)bos, transformationEncoding));
        State state = State.MAYBE_XML;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                switch (state) {
                    case MAYBE_XML: {
                        if (line.toLowerCase().startsWith("<?xml")) {
                            writer.println(line);
                            state = State.MAYBE_DOCTYPE;
                            break;
                        }
                    }
                    case MAYBE_DOCTYPE: {
                        if (line.trim().length() == 0) {
                            writer.println(line);
                            break;
                        }
                        String lineLower = line.toLowerCase();
                        if (lineLower.equals("<!doctype html>")) {
                            this.html5DTD = true;
                            writer.println(TRANSITIONAL_DOCTYPE);
                            state = State.JUST_COPY;
                            break;
                        }
                        if (lineLower.startsWith("<!doctype")) {
                            writer.println(line);
                            state = State.JUST_COPY;
                            break;
                        }
                        this.ignoreDTD = true;
                        this.lineOffset = -1;
                        writer.println(TRANSITIONAL_DOCTYPE);
                        state = State.JUST_COPY;
                    }
                    case JUST_COPY: {
                        writer.println(line);
                    }
                }
            }
        }
        finally {
            writer.close();
            reader.close();
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    private XMLToken token() {
        return this.cursor == -1 ? null : this.tokens.get(this.cursor);
    }

    public XMLTokenType next() {
        ++this.cursor;
        return this.getEventType();
    }

    public int getAttributeCount() {
        return this.token().attributes.size();
    }

    public QName getAttributeName(int i) {
        return this.token().attributes.get((int)i).attributeName;
    }

    public DTDData getDTDInfo() {
        return this.token().dtdData;
    }

    public XMLTokenType getEventType() {
        return this.token().type;
    }

    public String getLocalName() {
        return this.token().localName;
    }

    public Location getLocation() {
        if (this.exceptionLocation != null) {
            return this.exceptionLocation;
        }
        return this.token().getLocation();
    }

    public int getNamespaceCount() {
        return this.token().namespaceMappings.size();
    }

    public String getNamespacePrefix(int i) {
        return this.token().namespaceMappings.get((int)i).prefix;
    }

    public String getNamespaceURI() {
        return this.token().uri;
    }

    public String getNamespaceURI(int i) {
        return this.token().namespaceMappings.get((int)i).uri;
    }

    public String getText() {
        return this.token().text;
    }

    public boolean hasNext() {
        return this.cursor < this.tokens.size() - 1;
    }

    public String getAttributeValue(int i) {
        return this.token().attributes.get((int)i).value;
    }

    static enum State {
        MAYBE_XML,
        MAYBE_DOCTYPE,
        JUST_COPY;

    }

    private final class SaxHandler
    implements LexicalHandler,
    EntityResolver,
    ContentHandler {
        private Locator locator;
        private int currentLine = -1;
        private Location cachedLocation;
        private Location textLocation;
        private final StringBuilder builder = new StringBuilder();
        private boolean inCDATA;
        private boolean insideDTD;
        private List<NamespaceMapping> namespaceMappings = CollectionFactory.newList();

        private SaxHandler() {
        }

        private Location getLocation() {
            if (this.locator == null) {
                if (this.cachedLocation == null) {
                    this.cachedLocation = new LocationImpl(XMLTokenStream.this.resource);
                }
            } else {
                int line = this.locator.getLineNumber();
                if (this.currentLine != line) {
                    this.cachedLocation = null;
                }
                if (this.cachedLocation == null) {
                    this.cachedLocation = new LocationImpl(XMLTokenStream.this.resource, line + XMLTokenStream.this.lineOffset);
                }
            }
            return this.cachedLocation;
        }

        private XMLToken add(XMLTokenType type) {
            XMLToken token = new XMLToken(type, this.getLocation());
            XMLTokenStream.this.tokens.add(token);
            return token;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            URL url = (URL)XMLTokenStream.this.publicIdToURL.get(publicId);
            try {
                if (url != null) {
                    return new InputSource(url.openStream());
                }
            }
            catch (IOException ex) {
                throw new SAXException(String.format("Unable to open stream for resource %s: %s", url, ExceptionUtils.toMessage((Throwable)ex)), ex);
            }
            return null;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.insideDTD) {
                return;
            }
            this.add((XMLTokenType)XMLTokenType.COMMENT).text = new String(ch, start, length);
        }

        @Override
        public void startCDATA() throws SAXException {
            this.inCDATA = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.builder.length() != 0) {
                this.add((XMLTokenType)XMLTokenType.CDATA).text = this.builder.toString();
            }
            this.builder.setLength(0);
            this.inCDATA = false;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inCDATA) {
                this.builder.append(ch, start, length);
                return;
            }
            XMLToken token = new XMLToken(XMLTokenType.CHARACTERS, this.textLocation);
            token.text = new String(ch, start, length);
            XMLTokenStream.this.tokens.add(token);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.insideDTD = true;
            if (!XMLTokenStream.this.ignoreDTD) {
                DTDData data;
                this.add((XMLTokenType)XMLTokenType.DTD).dtdData = data = XMLTokenStream.this.html5DTD ? HTML5_DTD_DATA : new DTDData(name, publicId, systemId);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.add(XMLTokenType.END_DOCUMENT);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.add(XMLTokenType.END_ELEMENT);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private boolean ignoreURI(String uri) {
            return XMLTokenStream.this.ignoreDTD && uri.equals("http://www.w3.org/1999/xhtml");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Attributes2 a2;
            XMLToken token = this.add(XMLTokenType.START_ELEMENT);
            token.uri = this.ignoreURI(uri) ? "" : uri;
            token.localName = localName;
            token.qName = qName;
            Attributes2 attributes2 = a2 = attributes instanceof Attributes2 ? (Attributes2)attributes : null;
            if (attributes.getLength() == 0) {
                token.attributes = Collections.emptyList();
            } else {
                token.attributes = CollectionFactory.newList();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (a2 != null && !a2.isSpecified(i)) continue;
                    String prefixedName = attributes.getQName(i);
                    int lastColon = prefixedName.lastIndexOf(58);
                    String prefix = lastColon > 0 ? prefixedName.substring(0, lastColon) : "";
                    QName qname = new QName(attributes.getURI(i), attributes.getLocalName(i), prefix);
                    token.attributes.add(new AttributeInfo(qname, attributes.getValue(i)));
                }
            }
            token.namespaceMappings = CollectionFactory.newList(this.namespaceMappings);
            this.namespaceMappings.clear();
            this.textLocation = this.getLocation();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (XMLTokenStream.this.ignoreDTD && prefix.equals("") && uri.equals("http://www.w3.org/1999/xhtml")) {
                return;
            }
            this.namespaceMappings.add(new NamespaceMapping(prefix, uri));
        }

        @Override
        public void endDTD() throws SAXException {
            this.insideDTD = false;
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }
    }
}

