/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.http.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONLiteral;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.PathConstructor;
import org.apache.tapestry5.services.assets.StreamableResourceSource;
import org.apache.tapestry5.services.javascript.JavaScriptModuleConfiguration;
import org.apache.tapestry5.services.javascript.ModuleConfigurationCallback;
import org.apache.tapestry5.services.javascript.ModuleManager;

public class ModuleManagerImpl
implements ModuleManager {
    private final ResponseCompressionAnalyzer compressionAnalyzer;
    private final Messages globalMessages;
    private final boolean compactJSON;
    private final Map<String, Resource> shimModuleNameToResource = CollectionFactory.newMap();
    private final Resource classpathRoot;
    private final Set<String> extensions;
    private final Map<String, Resource> cache = CollectionFactory.newConcurrentMap();
    private final JSONObject baseConfig;
    private final String basePath;
    private final String compressedBasePath;

    public ModuleManagerImpl(ResponseCompressionAnalyzer compressionAnalyzer, AssetSource assetSource, Map<String, JavaScriptModuleConfiguration> configuration, Messages globalMessages, StreamableResourceSource streamableResourceSource, @Symbol(value="tapestry.compact-json") boolean compactJSON, @Symbol(value="tapestry.production-mode") boolean productionMode, @Symbol(value="tapestry.module-path-prefix") String modulePathPrefix, PathConstructor pathConstructor) {
        this.compressionAnalyzer = compressionAnalyzer;
        this.globalMessages = globalMessages;
        this.compactJSON = compactJSON;
        this.basePath = pathConstructor.constructClientPath(modulePathPrefix);
        this.compressedBasePath = pathConstructor.constructClientPath(modulePathPrefix + ".gz");
        this.classpathRoot = assetSource.resourceForPath("");
        this.extensions = CollectionFactory.newSet((Object[])new String[]{"js"});
        this.extensions.addAll(streamableResourceSource.fileExtensionsForContentType(InternalConstants.JAVASCRIPT_CONTENT_TYPE));
        this.baseConfig = this.buildBaseConfig(configuration, !productionMode);
    }

    private String buildRequireJSConfig(List<ModuleConfigurationCallback> callbacks) {
        JSONObject config = this.baseConfig.copy().put("baseUrl", (Object)this.getBaseURL());
        for (ModuleConfigurationCallback callback : callbacks) {
            config = callback.configure(config);
            assert (config != null);
        }
        return String.format("var require = %s;\n", config.toString(this.compactJSON));
    }

    private JSONObject buildBaseConfig(Map<String, JavaScriptModuleConfiguration> configuration, boolean devMode) {
        JSONObject config = new JSONObject();
        if (devMode) {
            config.put("waitSeconds", (Object)300);
        }
        for (String name : configuration.keySet()) {
            JavaScriptModuleConfiguration module = configuration.get(name);
            this.shimModuleNameToResource.put(name, module.resource);
            if (!module.getNeedsConfiguration()) continue;
            this.addModuleToConfig(config, name, module);
        }
        return config;
    }

    private String getBaseURL() {
        return this.compressionAnalyzer.isGZipSupported() ? this.compressedBasePath : this.basePath;
    }

    private void addModuleToConfig(JSONObject config, String name, JavaScriptModuleConfiguration module) {
        List<String> dependencies;
        String initExpression;
        JSONObject shimConfig = config.in("shim");
        boolean nestDependencies = false;
        String exports = module.getExports();
        if (exports != null) {
            shimConfig.in(name).put("exports", (Object)exports);
            nestDependencies = true;
        }
        if ((initExpression = module.getInitExpression()) != null) {
            String function = String.format("function() { return %s; }", initExpression);
            shimConfig.in(name).put("init", (Object)new JSONLiteral(function));
            nestDependencies = true;
        }
        if ((dependencies = module.getDependencies()) != null) {
            JSONObject container = nestDependencies ? shimConfig.in(name) : shimConfig;
            String key = nestDependencies ? "deps" : name;
            for (String dep : dependencies) {
                container.append(key, (Object)dep);
            }
        }
    }

    @PostInjection
    public void setupInvalidation(ResourceChangeTracker tracker) {
        tracker.clearOnInvalidation(this.cache);
    }

    @Override
    public void writeConfiguration(Element body, List<ModuleConfigurationCallback> callbacks) {
        Element element = body.element("script", "type", "text/javascript");
        element.raw(this.buildRequireJSConfig(callbacks));
    }

    @Override
    public void writeInitialization(Element body, List<String> libraryURLs, List<?> inits) {
        Element element = body.element("script", "type", "text/javascript");
        element.raw(this.globalMessages.format("private-core-page-initialization-template", new Object[]{this.convert(libraryURLs), this.convert(inits)}));
    }

    private String convert(List<?> input) {
        return new JSONArray().putAll(input).toString(this.compactJSON);
    }

    @Override
    public Resource findResourceForModule(String moduleName) {
        Resource resource = this.cache.get(moduleName);
        if (resource == null) {
            resource = this.resolveModuleNameToResource(moduleName);
            this.cache.put(moduleName, resource);
        }
        return resource == this.classpathRoot ? null : resource;
    }

    private Resource resolveModuleNameToResource(String moduleName) {
        Resource resource = this.shimModuleNameToResource.get(moduleName);
        if (resource != null) {
            return resource;
        }
        String baseName = String.format("/META-INF/modules/%s.EXT", moduleName);
        Resource baseResource = this.classpathRoot.forFile(baseName);
        for (String extension : this.extensions) {
            resource = baseResource.withExtension(extension);
            if (!resource.exists()) continue;
            return resource;
        }
        return this.classpathRoot;
    }
}

