/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.structure;

import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.commons.internal.util.MessagesImpl;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

final class StructureMessages {
    private static final Messages MESSAGES = MessagesImpl.forClass(StructureMessages.class);

    private StructureMessages() {
    }

    static String missingParameters(List<String> parameters, ComponentPageElement element) {
        return MESSAGES.format("missing-parameters", new Object[]{InternalUtils.joinSorted(parameters), element.getComponentResources().getComponentModel().getComponentClassName()});
    }

    static String unknownMixin(String componentId, String mixinClassName) {
        return MESSAGES.format("unknown-mixin", new Object[]{componentId, mixinClassName});
    }

    static String wrongPhaseResultType(List<String> expectedTypes) {
        return MESSAGES.format("wrong-phase-result-type", new Object[]{InternalUtils.join(expectedTypes)});
    }

    static String blockNotFound(String componentId, String blockId) {
        return MESSAGES.format("block-not-found", new Object[]{componentId, blockId});
    }

    static String unbalancedElements(String componentId) {
        return MESSAGES.format("unbalanced-elements", new Object[]{componentId});
    }

    static String duplicateChildComponent(ComponentPageElement container, String childId) {
        return MESSAGES.format("duplicate-child-component", new Object[]{container.getCompleteId(), childId});
    }

    static String originalChildComponent(ComponentPageElement container, String childId, Location originalLocation) {
        return MESSAGES.format("original-child-component", new Object[]{container.getCompleteId(), childId, originalLocation.getResource().getPath(), originalLocation.getLine()});
    }

    static String duplicateBlock(ComponentPageElement component, String blockId) {
        return MESSAGES.format("duplicate-block", new Object[]{component.getCompleteId(), blockId});
    }

    static String fieldPersistFailure(String componentId, String fieldName, Throwable cause) {
        return MESSAGES.format("field-persist-failure", new Object[]{componentId, fieldName, cause});
    }

    static String missingRenderVariable(String componentId, String name, Collection<String> names) {
        return MESSAGES.format("missing-render-variable", new Object[]{componentId, name, InternalUtils.joinSorted(names)});
    }

    static String persistChangeBeforeLoadComplete() {
        return MESSAGES.get("persist-change-before-load-complete");
    }
}

