/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PropertyAccessType;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class PropertyWorker
implements ComponentClassTransformWorker2 {
    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(Property.class)) {
            this.createAccessorsForField(field);
        }
    }

    private void createAccessorsForField(PlasticField field) {
        PropertyAccessType accessType = this.toType(field);
        field.createAccessors(accessType);
    }

    private PropertyAccessType toType(PlasticField field) {
        Property annotation = (Property)field.getAnnotation(Property.class);
        boolean read = annotation.read();
        boolean write = annotation.write();
        if (read && write) {
            return PropertyAccessType.READ_WRITE;
        }
        if (read) {
            return PropertyAccessType.READ_ONLY;
        }
        if (write) {
            return PropertyAccessType.WRITE_ONLY;
        }
        throw new IllegalArgumentException(String.format("@Property annotation on %s.%s should have either read() or write() enabled.", field.getPlasticClass().getClassName(), field.getName()));
    }
}

