/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.Stack;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClasspathMatcher;
import org.apache.tapestry5.ioc.services.ClasspathScanner;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;

public class ClasspathScannerImpl
implements ClasspathScanner {
    private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
    private final ClasspathURLConverter converter;
    private static final Pattern FOLDER_NAME_PATTERN = Pattern.compile("^\\p{javaJavaIdentifierStart}[\\p{javaJavaIdentifierPart}]*$", 2);

    public ClasspathScannerImpl(ClasspathURLConverter converter) {
        this.converter = converter;
    }

    @Override
    public Set<String> scan(String packagePath, ClasspathMatcher matcher) throws IOException {
        assert (packagePath != null && packagePath.endsWith("/"));
        assert (matcher != null);
        return new Job(matcher, this.contextClassLoader, this.converter).findMatches(packagePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean supportsDirStream(URL packageURL) {
        InputStream is = null;
        try {
            is = packageURL.openStream();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException ex) {
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            InternalUtils.close(is);
        }
    }

    private static JarFile getAlternativeJarFile(URL url) throws IOException {
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf(33);
        }
        if (separatorIndex != -1) {
            String jarFileUrl = urlFile.substring(0, separatorIndex);
            if (jarFileUrl.startsWith("file:")) {
                jarFileUrl = jarFileUrl.substring("file:".length());
            }
            return new JarFile(jarFileUrl);
        }
        return null;
    }

    static class Job {
        final ClasspathMatcher matcher;
        final ClasspathURLConverter converter;
        final ClassLoader classloader;
        final Set<String> matches = CollectionFactory.newSet();
        final Stack<IOWork> queue = CollectionFactory.newStack();

        Job(ClasspathMatcher matcher, ClassLoader classloader, ClasspathURLConverter converter) {
            this.matcher = matcher;
            this.classloader = classloader;
            this.converter = converter;
        }

        Set<String> findMatches(String packagePath) throws IOException {
            Enumeration<URL> urls = this.classloader.getResources(packagePath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                URL converted = this.converter.convert(url);
                this.scanURL(packagePath, converted);
                while (!this.queue.isEmpty()) {
                    IOWork queued = (IOWork)this.queue.pop();
                    queued.run();
                }
            }
            return this.matches;
        }

        void scanURL(final String packagePath, final URL url) throws IOException {
            URLConnection connection = url.openConnection();
            JarFile jarFile = connection instanceof JarURLConnection ? ((JarURLConnection)connection).getJarFile() : ClasspathScannerImpl.getAlternativeJarFile(url);
            if (jarFile != null) {
                this.scanJarFile(packagePath, jarFile);
            } else if (ClasspathScannerImpl.supportsDirStream(url)) {
                this.queue.push((Object)new IOWork(){

                    @Override
                    public void run() throws IOException {
                        this.scanDirStream(packagePath, url);
                    }
                });
            } else {
                this.scanDir(packagePath, new File(url.getFile()));
            }
        }

        private void scanDir(String packagePath, File packageDir) {
            if (packageDir.exists() && packageDir.isDirectory()) {
                for (final File file : packageDir.listFiles()) {
                    String fileName = file.getName();
                    if (file.isDirectory()) {
                        final String nestedPackagePath = packagePath + fileName + "/";
                        this.queue.push((Object)new IOWork(){

                            @Override
                            public void run() throws IOException {
                                this.scanDir(nestedPackagePath, file);
                            }
                        });
                    }
                    if (!this.matcher.matches(packagePath, fileName)) continue;
                    this.matches.add(packagePath + fileName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanDirStream(String packagePath, URL packageURL) throws IOException {
            BufferedInputStream is;
            try {
                is = new BufferedInputStream(packageURL.openStream());
            }
            catch (FileNotFoundException ex) {
                return;
            }
            InputStreamReader reader = new InputStreamReader(is);
            LineNumberReader lineReader = new LineNumberReader(reader);
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    if (this.matcher.matches(packagePath, line)) {
                        this.matches.add(packagePath + line);
                        continue;
                    }
                    if (!FOLDER_NAME_PATTERN.matcher(line).matches()) continue;
                    final URL newURL = new URL(packageURL.toExternalForm() + line + "/");
                    final String nestedPackagePath = packagePath + line + "/";
                    this.queue.push((Object)new IOWork(){

                        @Override
                        public void run() throws IOException {
                            this.scanURL(nestedPackagePath, newURL);
                        }
                    });
                }
                lineReader.close();
                lineReader = null;
            }
            finally {
                InternalUtils.close(lineReader);
            }
        }

        private void scanJarFile(String packagePath, JarFile jarFile) {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                String fileName;
                int lastSlashx;
                String filePackagePath;
                String name = e.nextElement().getName();
                if (!name.startsWith(packagePath) || !this.matcher.matches(filePackagePath = name.substring(0, (lastSlashx = name.lastIndexOf(47)) + 1), fileName = name.substring(lastSlashx + 1))) continue;
                this.matches.add(name);
            }
        }
    }

    static interface IOWork {
        public void run() throws IOException;
    }
}

