/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.ref.WeakReference;
import java.util.List;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.annotations.PreventServiceDecoration;
import org.apache.tapestry5.ioc.services.UpdateListener;
import org.apache.tapestry5.ioc.services.UpdateListenerHub;

@PreventServiceDecoration
public class UpdateListenerHubImpl
implements UpdateListenerHub {
    private final List<WeakReference<UpdateListener>> listeners = CollectionFactory.newThreadSafeList();

    @Override
    public void addUpdateListener(UpdateListener listener) {
        assert (listener != null);
        this.listeners.add(new WeakReference<UpdateListener>(listener));
    }

    @Override
    public void fireCheckForUpdates() {
        List deadReferences = CollectionFactory.newList();
        for (WeakReference<UpdateListener> reference : this.listeners) {
            UpdateListener listener = (UpdateListener)reference.get();
            if (listener == null) {
                deadReferences.add(reference);
                continue;
            }
            listener.checkForUpdates();
        }
        if (!deadReferences.isEmpty()) {
            this.listeners.removeAll(deadReferences);
        }
    }
}

