/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.zip.GZIPOutputStream;
import org.apache.tapestry5.internal.util.Base64OutputStream;
import org.apache.tapestry5.internal.util.MacOutputStream;
import org.apache.tapestry5.internal.util.TeeOutputStream;
import org.apache.tapestry5.services.ClientDataSink;
import org.apache.tapestry5.services.URLEncoder;

public class ClientDataSinkImpl
implements ClientDataSink {
    private final Base64OutputStream base64OutputStream;
    private final ObjectOutputStream objectOutputStream;
    private final URLEncoder urlEncoder;
    private boolean closed;
    private final MacOutputStream macOutputStream;

    public ClientDataSinkImpl(URLEncoder urlEncoder, Key hmacKey) throws IOException {
        this.urlEncoder = urlEncoder;
        this.base64OutputStream = new Base64OutputStream();
        this.macOutputStream = MacOutputStream.streamFor(hmacKey);
        final BufferedOutputStream pipeline = new BufferedOutputStream(new GZIPOutputStream(new TeeOutputStream(this.macOutputStream, this.base64OutputStream)));
        OutputStream guard = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                pipeline.write(b);
            }

            @Override
            public void close() throws IOException {
                ClientDataSinkImpl.this.closed = true;
                pipeline.close();
            }

            @Override
            public void flush() throws IOException {
                pipeline.flush();
            }

            @Override
            public void write(byte[] b) throws IOException {
                pipeline.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                pipeline.write(b, off, len);
            }
        };
        this.objectOutputStream = new ObjectOutputStream(guard);
    }

    @Override
    public ObjectOutputStream getObjectOutputStream() {
        return this.objectOutputStream;
    }

    @Override
    public String getClientData() {
        if (!this.closed) {
            try {
                this.objectOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.macOutputStream.getResult() + ":" + this.base64OutputStream.toBase64();
    }

    @Override
    public String getEncodedClientData() {
        return this.urlEncoder.encode(this.getClientData());
    }
}

