/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.util;

public class FastNumberFormat {
    public static final int MAX_COUNT = 19;
    private final char[] digits = new char[19];
    private int minimumIntegerDigits;

    public static FastNumberFormat getInstance() {
        return new FastNumberFormat();
    }

    public void setMinimumIntegerDigits(int minimumIntegerDigits) {
        this.minimumIntegerDigits = minimumIntegerDigits;
    }

    public StringBuilder format(long source, StringBuilder sb) {
        int left = 19;
        if (source < 0L) {
            sb.append('-');
            source = -source;
        }
        while (source > 0L) {
            this.digits[--left] = (char)(48L + source % 10L);
            source /= 10L;
        }
        while (19 - left < this.minimumIntegerDigits) {
            this.digits[--left] = 48;
        }
        sb.append(this.digits, left, 19 - left);
        return sb;
    }

    public String format(long source) {
        return this.format(source, new StringBuilder()).toString();
    }
}

