/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.http;

import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.KeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.ssl.SSLHostnameVerifier;
import org.apache.hadoop.util.ReflectionUtils;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SSLFactory
implements ConnectionConfigurator {
    public static final String SSL_ENABLED_PROTOCOLS = "hadoop.ssl.enabled.protocols";
    public static final String DEFAULT_SSL_ENABLED_PROTOCOLS = "TLSv1";
    public static final boolean DEFAULT_SSL_REQUIRE_CLIENT_CERT = false;
    private Configuration conf;
    private SSLFactory.Mode mode;
    private boolean requireClientCert;
    private SSLContext context;
    private HostnameVerifier hostnameVerifier;
    private KeyStoresFactory keystoresFactory;
    private String[] enabledProtocols = null;

    public SSLFactory(SSLFactory.Mode mode, Configuration conf) {
        this.conf = conf;
        if (mode == null) {
            throw new IllegalArgumentException("mode cannot be NULL");
        }
        this.mode = mode;
        this.requireClientCert = conf.getBoolean("hadoop.ssl.require.client.cert", false);
        conf.setBoolean("hadoop.ssl.require.client.cert", this.requireClientCert);
        Class klass = conf.getClass("hadoop.ssl.keystores.factory.class", FileBasedKeyStoresFactory.class, KeyStoresFactory.class);
        this.keystoresFactory = (KeyStoresFactory)ReflectionUtils.newInstance((Class)klass, (Configuration)conf);
        this.enabledProtocols = conf.getStrings(SSL_ENABLED_PROTOCOLS, new String[]{DEFAULT_SSL_ENABLED_PROTOCOLS});
    }

    private Configuration readSSLConfiguration(SSLFactory.Mode mode) {
        Configuration sslConf = new Configuration(false);
        sslConf.setBoolean("hadoop.ssl.require.client.cert", this.requireClientCert);
        String sslConfResource = mode == SSLFactory.Mode.CLIENT ? this.conf.get("hadoop.ssl.client.conf", "ssl-client.xml") : this.conf.get("hadoop.ssl.server.conf", "ssl-server.xml");
        sslConf.addResource(sslConfResource);
        return sslConf;
    }

    public void init() throws GeneralSecurityException, IOException {
        this.keystoresFactory.init(this.mode);
        this.context = SSLContext.getInstance("TLS");
        this.context.init(this.keystoresFactory.getKeyManagers(), this.keystoresFactory.getTrustManagers(), null);
        this.context.getDefaultSSLParameters().setProtocols(this.enabledProtocols);
        this.hostnameVerifier = this.getHostnameVerifier(this.conf);
    }

    private HostnameVerifier getHostnameVerifier(Configuration conf) throws GeneralSecurityException, IOException {
        return SSLFactory.getHostnameVerifier(conf.get("hadoop.ssl.hostname.verifier", "DEFAULT").trim().toUpperCase());
    }

    public static HostnameVerifier getHostnameVerifier(String verifier) throws GeneralSecurityException, IOException {
        SSLHostnameVerifier hostnameVerifier;
        if (verifier.equals("DEFAULT")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT;
        } else if (verifier.equals("DEFAULT_AND_LOCALHOST")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT_AND_LOCALHOST;
        } else if (verifier.equals("STRICT")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT;
        } else if (verifier.equals("STRICT_IE6")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT_IE6;
        } else if (verifier.equals("ALLOW_ALL")) {
            hostnameVerifier = SSLHostnameVerifier.ALLOW_ALL;
        } else {
            throw new GeneralSecurityException("Invalid hostname verifier: " + verifier);
        }
        return hostnameVerifier;
    }

    public void destroy() {
        this.keystoresFactory.destroy();
    }

    public KeyStoresFactory getKeystoresFactory() {
        return this.keystoresFactory;
    }

    public SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException, IOException {
        if (this.mode != SSLFactory.Mode.CLIENT) {
            throw new IllegalStateException("Factory is in CLIENT mode");
        }
        return this.context.getSocketFactory();
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.mode != SSLFactory.Mode.CLIENT) {
            throw new IllegalStateException("Factory is in CLIENT mode");
        }
        return this.hostnameVerifier;
    }

    public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sslConn = (HttpsURLConnection)conn;
            try {
                sslConn.setSSLSocketFactory(this.createSSLSocketFactory());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            sslConn.setHostnameVerifier(this.getHostnameVerifier());
            conn = sslConn;
        }
        return conn;
    }

    public void configure(DefaultAsyncHttpClientConfig.Builder builder) throws IOException {
        if (builder != null) {
            JdkSslContext jdkSslContext = new JdkSslContext(this.context, this.mode.equals((Object)SSLFactory.Mode.CLIENT), null, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, null, this.requireClientCert ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL, this.enabledProtocols, true);
            builder.setSslContext((SslContext)jdkSslContext);
        }
    }
}

