/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.GuavaShim;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleInputEventHandlerOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleScheduler;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.tez.runtime.library.exceptions.InputAlreadyClosedException;
import org.apache.tez.runtime.library.utils.CodecUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Shuffle
implements ExceptionReporter {
    private static final Logger LOG = LoggerFactory.getLogger(Shuffle.class);
    private static final int PROGRESS_FREQUENCY = 2000;
    private final Configuration conf;
    private final InputContext inputContext;
    private final ShuffleInputEventHandlerOrderedGrouped eventHandler;
    @VisibleForTesting
    final ShuffleScheduler scheduler;
    @VisibleForTesting
    final MergeManager merger;
    private final CompressionCodec codec;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private AtomicReference<Throwable> throwable = new AtomicReference();
    private String throwingThreadName = null;
    private final RunShuffleCallable runShuffleCallable;
    private volatile ListenableFuture<TezRawKeyValueIterator> runShuffleFuture;
    private final ListeningExecutorService executor;
    private final String srcNameTrimmed;
    private AtomicBoolean isShutDown = new AtomicBoolean(false);
    private AtomicBoolean fetchersClosed = new AtomicBoolean(false);
    private AtomicBoolean schedulerClosed = new AtomicBoolean(false);
    private AtomicBoolean mergerClosed = new AtomicBoolean(false);
    private final long startTime;
    private final TezCounter mergePhaseTime;
    private final TezCounter shufflePhaseTime;

    public Shuffle(InputContext inputContext, Configuration conf, int numInputs, long initialMemoryAvailable) throws IOException {
        this.inputContext = inputContext;
        this.conf = conf;
        this.srcNameTrimmed = TezUtilsInternal.cleanVertexName((String)inputContext.getSourceVertexName());
        this.codec = CodecUtils.getCodec(conf);
        this.ifileReadAhead = conf.getBoolean("tez.runtime.ifile.readahead", true);
        this.ifileReadAheadLength = this.ifileReadAhead ? conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000) : 0;
        Combiner combiner = TezRuntimeUtils.instantiateCombiner(conf, (TaskContext)inputContext);
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)this.conf);
        LocalDirAllocator localDirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        TezCounter spilledRecordsCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SPILLED_RECORDS);
        TezCounter reduceCombineInputCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS);
        TezCounter mergedMapOutputsCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.MERGED_MAP_OUTPUTS);
        LOG.info(this.srcNameTrimmed + ": Shuffle assigned with " + numInputs + " inputs, codec: " + (this.codec == null ? "None" : this.codec.getClass().getName()) + ", ifileReadAhead: " + this.ifileReadAhead);
        this.startTime = System.currentTimeMillis();
        this.merger = new MergeManager(this.conf, (FileSystem)localFS, localDirAllocator, inputContext, combiner, spilledRecordsCounter, reduceCombineInputCounter, mergedMapOutputsCounter, this, initialMemoryAvailable, this.codec, this.ifileReadAhead, this.ifileReadAheadLength);
        this.scheduler = new ShuffleScheduler(this.inputContext, this.conf, numInputs, this, this.merger, this.merger, this.startTime, this.codec, this.ifileReadAhead, this.ifileReadAheadLength, this.srcNameTrimmed);
        this.mergePhaseTime = inputContext.getCounters().findCounter((Enum)TaskCounter.MERGE_PHASE_TIME);
        this.shufflePhaseTime = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_PHASE_TIME);
        this.eventHandler = new ShuffleInputEventHandlerOrderedGrouped(inputContext, this.scheduler, ShuffleUtils.isTezShuffleHandler(conf));
        ExecutorService rawExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShuffleAndMergeRunner {" + this.srcNameTrimmed + "}").build());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
        this.runShuffleCallable = new RunShuffleCallable();
    }

    public void handleEvents(List<Event> events) throws IOException {
        if (!this.isShutDown.get()) {
            this.eventHandler.handleEvents(events);
        } else {
            LOG.info(this.srcNameTrimmed + ": Ignoring events since already shutdown. EventCount: " + events.size());
        }
    }

    public boolean isInputReady() throws IOException, InterruptedException, TezException {
        if (this.isShutDown.get()) {
            throw new InputAlreadyClosedException();
        }
        if (this.throwable.get() != null) {
            this.handleThrowable(this.throwable.get());
        }
        if (this.runShuffleFuture == null) {
            return false;
        }
        return this.runShuffleFuture.isDone();
    }

    private void handleThrowable(Throwable t) throws IOException, InterruptedException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof InterruptedException) {
            throw (InterruptedException)t;
        }
        throw new UndeclaredThrowableException(t);
    }

    public TezRawKeyValueIterator waitForInput() throws IOException, InterruptedException, TezException {
        Preconditions.checkState((this.runShuffleFuture != null ? 1 : 0) != 0, (Object)"waitForInput can only be called after run");
        TezRawKeyValueIterator kvIter = null;
        try {
            kvIter = (TezRawKeyValueIterator)this.runShuffleFuture.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            this.handleThrowable(cause);
        }
        if (this.isShutDown.get()) {
            throw new InputAlreadyClosedException();
        }
        if (this.throwable.get() != null) {
            this.handleThrowable(this.throwable.get());
        }
        return kvIter;
    }

    public void run() throws IOException {
        this.merger.configureAndStart();
        this.runShuffleFuture = this.executor.submit((Callable)((Object)this.runShuffleCallable));
        Futures.addCallback(this.runShuffleFuture, (FutureCallback)new ShuffleRunnerFutureCallback(), (Executor)GuavaShim.directExecutor());
        this.executor.shutdown();
    }

    public void shutdown() {
        if (!this.isShutDown.getAndSet(true)) {
            LOG.info("Shutting down Shuffle for source: " + this.srcNameTrimmed);
            this.runShuffleFuture.cancel(true);
            this.cleanupIgnoreErrors();
        }
    }

    private void cleanupShuffleSchedulerIgnoreErrors() {
        try {
            this.cleanupShuffleScheduler();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info(this.srcNameTrimmed + ": Interrupted while attempting to close the scheduler during cleanup. Ignoring");
        }
    }

    private void cleanupShuffleScheduler() throws InterruptedException {
        if (!this.schedulerClosed.getAndSet(true)) {
            this.scheduler.close();
        }
    }

    private void cleanupMerger(boolean ignoreErrors) throws Throwable {
        if (!this.mergerClosed.getAndSet(true)) {
            try {
                this.merger.close(false);
            }
            catch (InterruptedException e) {
                if (ignoreErrors) {
                    Thread.currentThread().interrupt();
                    LOG.info(this.srcNameTrimmed + ": Interrupted while attempting to close the merger during cleanup. Ignoring");
                }
                throw e;
            }
            catch (Throwable e) {
                if (ignoreErrors) {
                    LOG.info(this.srcNameTrimmed + ": Exception while trying to shutdown merger, Ignoring", e);
                }
                throw e;
            }
        }
    }

    private void cleanupIgnoreErrors() {
        try {
            if (this.eventHandler != null) {
                this.eventHandler.logProgress(true);
            }
            try {
                this.cleanupShuffleSchedulerIgnoreErrors();
            }
            catch (Exception e) {
                LOG.warn("Error cleaning up shuffle scheduler. Ignoring and continuing with shutdown. Message={}", (Object)e.getMessage());
            }
            this.cleanupMerger(true);
        }
        catch (Throwable t) {
            LOG.info(this.srcNameTrimmed + ": Error in cleaning up.., ", t);
        }
    }

    @Override
    @InterfaceAudience.Private
    public synchronized void reportException(Throwable t) {
        if (this.throwable.get() == null) {
            LOG.info(this.srcNameTrimmed + ": Setting throwable in reportException with message [" + t.getMessage() + "] from thread [" + Thread.currentThread().getName());
            this.throwable.set(t);
            this.throwingThreadName = Thread.currentThread().getName();
            this.cleanupShuffleSchedulerIgnoreErrors();
        }
    }

    @Override
    @InterfaceAudience.Private
    public synchronized void killSelf(Exception exception, String message) {
        if (!this.isShutDown.get() && this.throwable.get() == null) {
            this.shutdown();
            this.inputContext.killSelf((Throwable)exception, message);
        }
    }

    @InterfaceAudience.Private
    public static long getInitialMemoryRequirement(Configuration conf, long maxAvailableTaskMemory) {
        return MergeManager.getInitialMemoryRequirement(conf, maxAvailableTaskMemory);
    }

    private class ShuffleRunnerFutureCallback
    implements FutureCallback<TezRawKeyValueIterator> {
        private ShuffleRunnerFutureCallback() {
        }

        public void onSuccess(TezRawKeyValueIterator result) {
            LOG.info(Shuffle.this.srcNameTrimmed + ": Shuffle Runner thread complete");
        }

        public void onFailure(Throwable t) {
            if (Shuffle.this.isShutDown.get()) {
                LOG.info(Shuffle.this.srcNameTrimmed + ": Already shutdown. Ignoring error");
            } else {
                LOG.error(Shuffle.this.srcNameTrimmed + ": ShuffleRunner failed with error", t);
                Shuffle.this.inputContext.reportFailure(TaskFailureType.NON_FATAL, t, "Shuffle Runner Failed");
                Shuffle.this.cleanupIgnoreErrors();
            }
        }
    }

    public static class ShuffleError
    extends IOException {
        private static final long serialVersionUID = 5753909320586607881L;

        ShuffleError(String msg, Throwable t) {
            super(msg, t);
        }
    }

    private class RunShuffleCallable
    extends CallableWithNdc<TezRawKeyValueIterator> {
        private RunShuffleCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TezRawKeyValueIterator callInternal() throws IOException, InterruptedException {
            if (!Shuffle.this.isShutDown.get()) {
                try {
                    Shuffle.this.scheduler.start();
                }
                catch (Throwable e) {
                    throw new ShuffleError("Error during shuffle", e);
                }
                finally {
                    Shuffle.this.cleanupShuffleScheduler();
                }
            }
            Shuffle e = Shuffle.this;
            synchronized (e) {
                if (Shuffle.this.throwable.get() != null) {
                    throw new ShuffleError("error in shuffle in " + Shuffle.this.throwingThreadName, (Throwable)Shuffle.this.throwable.get());
                }
            }
            Shuffle.this.shufflePhaseTime.setValue(System.currentTimeMillis() - Shuffle.this.startTime);
            Shuffle.this.cleanupShuffleScheduler();
            TezRawKeyValueIterator kvIter = null;
            Shuffle.this.inputContext.notifyProgress();
            try {
                kvIter = Shuffle.this.merger.close(true);
            }
            catch (Throwable e2) {
                Shuffle.this.throwable.set(e2);
                throw new ShuffleError("Error while doing final merge ", e2);
            }
            Shuffle.this.mergePhaseTime.setValue(System.currentTimeMillis() - Shuffle.this.startTime);
            Shuffle.this.inputContext.notifyProgress();
            Shuffle shuffle = Shuffle.this;
            synchronized (shuffle) {
                if (Shuffle.this.throwable.get() != null) {
                    throw new ShuffleError("error in shuffle in " + Shuffle.this.throwingThreadName, (Throwable)Shuffle.this.throwable.get());
                }
            }
            Shuffle.this.inputContext.inputIsReady();
            LOG.info("merge complete for input vertex : " + Shuffle.this.srcNameTrimmed);
            return kvIter;
        }
    }
}

