/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.history.parser.datamodel;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.Event;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.TaskInfo;
import org.apache.tez.history.parser.datamodel.VersionInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public abstract class BaseParser {
    protected DagInfo dagInfo;
    protected VersionInfo versionInfo;
    protected Map<String, String> config;
    protected final List<VertexInfo> vertexList = Lists.newLinkedList();
    protected final List<TaskInfo> taskList = Lists.newLinkedList();
    protected final List<TaskAttemptInfo> attemptList = Lists.newLinkedList();

    protected boolean checkFiles(List<File> files) {
        if (files.isEmpty()) {
            return false;
        }
        for (File file : files) {
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    protected void addRawDataToDagInfo() {
        this.dagInfo.addMeta("vertices", this.vertexList);
        this.dagInfo.addMeta("tasks", this.taskList);
        this.dagInfo.addMeta("taskAttempts", this.attemptList);
    }

    protected void linkParsedContents() {
        VertexInfo vertexInfo;
        for (VertexInfo vertexInfo2 : this.vertexList) {
            vertexInfo2.setDagInfo(this.dagInfo);
        }
        for (TaskInfo taskInfo : this.taskList) {
            String vertexId = TezTaskID.fromString((String)taskInfo.getTaskId()).getVertexID().toString();
            vertexInfo = this.dagInfo.getVertexFromId(vertexId);
            Preconditions.checkState((vertexInfo != null ? 1 : 0) != 0, (Object)("VertexInfo for " + vertexId + " can't be null"));
            taskInfo.setVertexInfo(vertexInfo);
        }
        for (TaskAttemptInfo attemptInfo : this.attemptList) {
            TezTaskAttemptID taskAttemptId = TezTaskAttemptID.fromString((String)attemptInfo.getTaskAttemptId());
            vertexInfo = this.dagInfo.getVertexFromId(taskAttemptId.getTaskID().getVertexID().toString());
            Preconditions.checkState((vertexInfo != null ? 1 : 0) != 0, (Object)("Vertex " + taskAttemptId.getTaskID().getVertexID().toString() + " is not present in DAG"));
            TaskInfo taskInfo = vertexInfo.getTask(taskAttemptId.getTaskID().toString());
            attemptInfo.setTaskInfo(taskInfo);
        }
        for (VertexInfo vertexInfo2 : this.dagInfo.getVertices()) {
            for (TaskAttemptInfo taskAttemptInfo : vertexInfo2.getTaskAttempts()) {
                this.dagInfo.addContainerMapping(taskAttemptInfo.getContainer(), taskAttemptInfo);
            }
        }
        for (VertexInfo vertexInfo2 : this.dagInfo.getVertices()) {
            this.setReferenceTime(vertexInfo2.getEvents(), this.dagInfo.getStartTimeInterval());
            for (TaskInfo taskInfo : vertexInfo2.getTasks()) {
                this.setReferenceTime(taskInfo.getEvents(), this.dagInfo.getStartTimeInterval());
                for (TaskAttemptInfo taskAttemptInfo : taskInfo.getTaskAttempts()) {
                    this.setReferenceTime(taskAttemptInfo.getEvents(), this.dagInfo.getStartTimeInterval());
                }
            }
        }
        this.dagInfo.setVersionInfo(this.versionInfo);
        this.dagInfo.setAppConfig(this.config);
    }

    private void setReferenceTime(List<Event> eventList, final long referenceTime) {
        Iterables.all(eventList, (Predicate)new Predicate<Event>(){

            public boolean apply(Event input) {
                input.setReferenceTime(referenceTime);
                return false;
            }
        });
    }

    protected void setUserName(String userName) {
        Preconditions.checkArgument((this.dagInfo != null ? 1 : 0) != 0, (Object)"DagInfo can not be null");
        this.dagInfo.setUserName(userName);
    }
}

