/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class ShuffleTimeAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private static final String REAL_WORK_DONE_RATIO = "tez.shuffle-time-analyzer.real-work.done.ratio";
    private static final float REAL_WORK_DONE_RATIO_DEFAULT = 0.5f;
    private static final String MIN_SHUFFLE_RECORDS = "tez.shuffle-time-analyzer.shuffle.min.records";
    private static final long MIN_SHUFFLE_RECORDS_DEFAULT = 10000L;
    private static final String[] headers = new String[]{"vertexName", "taskAttemptId", "Node", "counterGroup", "Comments", "REDUCE_INPUT_GROUPS", "REDUCE_INPUT_RECORDS", "ratio", "SHUFFLE_BYTES", "TotalTime", "Time_taken_to_receive_all_events", "MERGE_PHASE_TIME", "SHUFFLE_PHASE_TIME", "TimeTaken_For_Real_Task", "FIRST_EVENT_RECEIVED", "LAST_EVENT_RECEIVED", "SHUFFLE_BYTES_DISK_DIRECT"};
    private final CSVResult csvResult = new CSVResult(headers);
    private final Configuration config;
    private final float realWorkDoneRatio;
    private final long minShuffleRecords;

    public ShuffleTimeAnalyzer(Configuration config) {
        this.config = config;
        this.realWorkDoneRatio = config.getFloat(REAL_WORK_DONE_RATIO, 0.5f);
        this.minShuffleRecords = config.getLong(MIN_SHUFFLE_RECORDS, 10000L);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        for (VertexInfo vertexInfo : dagInfo.getVertices()) {
            for (TaskAttemptInfo attemptInfo : vertexInfo.getTaskAttempts()) {
                Map reduceInputGroups = attemptInfo.getCounter(TaskCounter.REDUCE_INPUT_GROUPS.toString());
                Map reduceInputRecords = attemptInfo.getCounter(TaskCounter.REDUCE_INPUT_RECORDS.toString());
                if (reduceInputGroups == null) continue;
                for (Map.Entry entry : reduceInputGroups.entrySet()) {
                    float ratio;
                    String counterGroupName = (String)entry.getKey();
                    long reduceInputGroupsVal = ((TezCounter)entry.getValue()).getValue();
                    long reduceInputRecordsVal = reduceInputRecords.get(counterGroupName) != null ? ((TezCounter)reduceInputRecords.get(counterGroupName)).getValue() : 0L;
                    if (reduceInputRecordsVal <= 0L || !((ratio = (float)reduceInputGroupsVal * 1.0f / (float)reduceInputRecordsVal) > 0.0f) || reduceInputRecordsVal <= this.minShuffleRecords) continue;
                    LinkedList result = Lists.newLinkedList();
                    result.add(vertexInfo.getVertexName());
                    result.add(attemptInfo.getTaskAttemptId());
                    result.add(attemptInfo.getNodeId());
                    result.add(counterGroupName);
                    String comments = "";
                    String mergePhaseTime = this.getCounterValue(TaskCounter.MERGE_PHASE_TIME, counterGroupName, attemptInfo);
                    String timeTakenForRealWork = "";
                    if (!Strings.isNullOrEmpty((String)mergePhaseTime)) {
                        long realWorkDone = attemptInfo.getTimeTaken() - Long.parseLong(mergePhaseTime);
                        if ((float)realWorkDone * 1.0f / (float)attemptInfo.getTimeTaken() < this.realWorkDoneRatio) {
                            comments = "Time taken in shuffle is more than the actual work being done in task.  Check if source/destination machine is a slow node. Check if merge phase time is more to understand disk bottlenecks in this node.  Check for skew";
                        }
                        timeTakenForRealWork = Long.toString(realWorkDone);
                    }
                    result.add(comments);
                    result.add(reduceInputGroupsVal + "");
                    result.add(reduceInputRecordsVal + "");
                    result.add("" + 1.0f * (float)reduceInputGroupsVal / (float)reduceInputRecordsVal);
                    result.add(this.getCounterValue(TaskCounter.SHUFFLE_BYTES, counterGroupName, attemptInfo));
                    result.add(Long.toString(attemptInfo.getTimeTaken()));
                    result.add(this.getOverheadFromSourceTasks(counterGroupName, attemptInfo));
                    result.add(this.getCounterValue(TaskCounter.MERGE_PHASE_TIME, counterGroupName, attemptInfo));
                    result.add(this.getCounterValue(TaskCounter.SHUFFLE_PHASE_TIME, counterGroupName, attemptInfo));
                    result.add(timeTakenForRealWork);
                    result.add(this.getCounterValue(TaskCounter.FIRST_EVENT_RECEIVED, counterGroupName, attemptInfo));
                    result.add(this.getCounterValue(TaskCounter.LAST_EVENT_RECEIVED, counterGroupName, attemptInfo));
                    result.add(this.getCounterValue(TaskCounter.SHUFFLE_BYTES_DISK_DIRECT, counterGroupName, attemptInfo));
                    this.csvResult.addRecord(result.toArray(new String[result.size()]));
                }
            }
        }
    }

    private String getOverheadFromSourceTasks(String counterGroupName, TaskAttemptInfo attemptInfo) {
        String firstEventReceived = this.getCounterValue(TaskCounter.FIRST_EVENT_RECEIVED, counterGroupName, attemptInfo);
        String lastEventReceived = this.getCounterValue(TaskCounter.LAST_EVENT_RECEIVED, counterGroupName, attemptInfo);
        if (!Strings.isNullOrEmpty((String)firstEventReceived) && !Strings.isNullOrEmpty((String)lastEventReceived)) {
            return Long.toString(Long.parseLong(lastEventReceived) - Long.parseLong(firstEventReceived));
        }
        return "";
    }

    private String getCounterValue(TaskCounter counter, String counterGroupName, TaskAttemptInfo attemptInfo) {
        Map tezCounterMap = attemptInfo.getCounter(counter.toString());
        if (tezCounterMap != null) {
            for (Map.Entry entry : tezCounterMap.entrySet()) {
                String groupName = (String)entry.getKey();
                long val = ((TezCounter)entry.getValue()).getValue();
                if (!groupName.equals(counterGroupName)) continue;
                return Long.toString(val);
            }
        }
        return "";
    }

    @Override
    public CSVResult getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Shuffle time analyzer";
    }

    @Override
    public String getDescription() {
        return "Analyze the time taken for shuffle, merge and the real work done in the task";
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        ShuffleTimeAnalyzer analyzer = new ShuffleTimeAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

